/*
 * Decompiled with CFR 0.152.
 */
package fabric.net;

import fabric.common.exceptions.InternalError;
import fabric.common.net.naming.SocketAddress;
import fabric.net.CommManager;
import fabric.net.Stream;
import java.io.IOException;
import java.io.Serializable;

public abstract class RemoteNode
implements Serializable {
    public final String name;
    private final transient boolean supportsUnencrypted;
    private transient CommManager sslCommManager;
    private transient CommManager unencryptedCommManager;

    protected RemoteNode(String name, boolean supportsUnencrypted) {
        this.name = name;
        this.sslCommManager = null;
        this.unencryptedCommManager = null;
        this.supportsUnencrypted = supportsUnencrypted;
    }

    protected abstract SocketAddress lookup() throws IOException;

    public final String name() {
        return this.name;
    }

    public final Stream openStream(boolean useSSL) {
        if (useSSL) {
            if (this.sslCommManager == null) {
                this.sslCommManager = new CommManager(this, true);
            }
            return this.sslCommManager.openStream();
        }
        if (!this.supportsUnencrypted) {
            throw new InternalError("Attempted to establish an unencrypted connection to a node that does not support it.");
        }
        if (this.unencryptedCommManager == null) {
            this.unencryptedCommManager = new CommManager(this, false);
        }
        return this.unencryptedCommManager.openStream();
    }

    public void cleanup() {
        if (this.sslCommManager != null) {
            this.sslCommManager.shutdown();
        }
        if (this.unencryptedCommManager != null) {
            this.unencryptedCommManager.shutdown();
        }
    }
}

