/*
 * Decompiled with CFR 0.152.
 */
package fabric.net;

import fabric.common.Logging;
import fabric.common.Options;
import fabric.common.exceptions.InternalError;
import fabric.common.exceptions.NoSuchNodeError;
import fabric.common.net.naming.SocketAddress;
import fabric.lang.security.NodePrincipal;
import fabric.net.ChannelMultiplexerThread;
import fabric.net.RemoteNode;
import fabric.net.Stream;
import fabric.net.UnreachableNodeException;
import fabric.worker.Worker;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.Channels;
import java.nio.channels.Pipe;
import java.nio.channels.SocketChannel;
import java.security.Principal;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import javax.security.auth.x500.X500Principal;

class CommManager {
    private final RemoteNode node;
    private final ChannelMultiplexerThread muxer;
    private final boolean useSSL;

    CommManager(RemoteNode remoteNode, boolean useSSL) {
        this.node = remoteNode;
        this.useSSL = useSSL;
        SocketChannel socketChannel = this.connect();
        ChannelMultiplexerThread.CallbackHandler handler = new ChannelMultiplexerThread.CallbackHandler(){

            @Override
            public void newStream(ChannelMultiplexerThread muxer, int streamID) {
                throw new InternalError("Unexpected stream ID: " + streamID);
            }

            @Override
            public void connectionClosed() {
                throw new InternalError("Connection to " + CommManager.this.node + " unexpectedly closed.");
            }

            @Override
            public void shutdown() {
            }
        };
        try {
            this.muxer = new ChannelMultiplexerThread(handler, "Thread for communicating with node " + remoteNode.name, socketChannel);
        }
        catch (IOException e) {
            throw new InternalError(e);
        }
        this.muxer.start();
    }

    private SocketChannel connect() {
        Worker worker = Worker.getWorker();
        int hostIdx = 0;
        List<InetSocketAddress> hosts = null;
        X500Principal nodePrincipal = null;
        int numHosts = 0;
        int startHostIdx = 0;
        int retry = 0;
        while (worker.retries < 0 || retry < worker.retries) {
            try {
                if (hosts == null) {
                    SocketAddress addr = this.node.lookup();
                    nodePrincipal = new X500Principal("cn=" + this.node.name());
                    hosts = Collections.singletonList(addr.toInetSocketAddress());
                    numHosts = 1;
                    startHostIdx = 0;
                }
                int hostNum = (startHostIdx + hostIdx) % numHosts;
                return this.connect((InetSocketAddress)hosts.get(hostNum), nodePrincipal);
            }
            catch (NoSuchNodeError e) {
                Logging.NETWORK_CONNECTION_LOGGER.log(Level.WARNING, "Failed to connect to " + this.node.name(), e);
                if (++hostIdx != numHosts) continue;
                hostIdx = 0;
                if (worker.retries < 0) continue;
                ++retry;
            }
            catch (IOException e) {
                Logging.NETWORK_CONNECTION_LOGGER.log(Level.WARNING, "Failed to connect to " + this.node.name(), e);
                if (hosts == null || ++hostIdx != numHosts) continue;
                hostIdx = 0;
                if (worker.retries < 0) continue;
                ++retry;
            }
        }
        throw new UnreachableNodeException(this.node);
    }

    private SocketChannel connect(InetSocketAddress addr, Principal remotePrincipal) throws NoSuchNodeError, IOException {
        Worker worker = Worker.getWorker();
        SocketChannel socketChannel = SocketChannel.open();
        socketChannel.configureBlocking(true);
        Socket socket = socketChannel.socket();
        socket.setTcpNoDelay(true);
        socket.setKeepAlive(true);
        socketChannel.socket().connect(addr, worker.timeout);
        DataOutputStream dataOut = new DataOutputStream(socket.getOutputStream());
        dataOut.writeUTF(this.node.name);
        dataOut.writeUTF(Worker.getWorker().name);
        dataOut.writeBoolean(this.useSSL);
        dataOut.flush();
        if (socket.getInputStream().read() == 0) {
            throw new NoSuchNodeError();
        }
        return this.initializeSession(socketChannel, dataOut);
    }

    private SocketChannel initializeSession(SocketChannel connection, DataOutputStream out) throws IOException {
        Worker worker = Worker.getWorker();
        if (!this.useSSL) {
            return connection;
        }
        if (!Options.DEBUG_NO_SSL) {
            out.writeUTF(worker.javaPrincipal.getName());
            out.flush();
        } else {
            out.writeUTF(worker.javaPrincipal.getName());
            out.flush();
        }
        NodePrincipal principal = worker.getPrincipal();
        out.write(principal != null ? 1 : 0);
        if (principal != null) {
            out.writeUTF(principal.$getStore().name());
            out.writeLong(principal.$getOnum());
        }
        out.flush();
        return connection;
    }

    public Stream openStream() {
        try {
            Pipe inbound = Pipe.open();
            Pipe outbound = Pipe.open();
            int streamID = this.muxer.registerChannels(outbound.source(), inbound.sink());
            inbound.source().configureBlocking(true);
            outbound.sink().configureBlocking(true);
            DataInputStream in = new DataInputStream(new BufferedInputStream(Channels.newInputStream(inbound.source())));
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(Channels.newOutputStream(outbound.sink())));
            return new Stream(this.muxer, streamID, in, out);
        }
        catch (IOException e) {
            throw new InternalError(e);
        }
    }

    public void shutdown() {
        this.muxer.shutdown();
    }
}

