/*
 * Decompiled with CFR 0.152.
 */
package fabric.net;

import fabric.common.exceptions.InternalError;
import fabric.common.util.MutableInteger;
import fabric.common.util.Pair;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.Pipe;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.WeakHashMap;

public final class ChannelMultiplexerThread
extends Thread {
    public static final int BUFFER_SIZE = 8192;
    private static final int BUFFER_POOL_SIZE = 100;
    private final SocketChannel socketChannel;
    private final CallbackHandler callback;
    private final Map<Integer, Pair<Pipe.SinkChannel, Queue<ByteBuffer>>> sinkChannelByStreamID;
    private final Map<Pipe.SinkChannel, Queue<ByteBuffer>> bufferQueueBySinkChannel;
    private final Map<Pipe.SourceChannel, Integer> streamIDBySourceChannel;
    private final Queue<Pipe.SourceChannel> readQueue;
    private volatile boolean destroyed;
    private final BufferPool bufferPool;
    private final MutableInteger nextStreamID;
    private ByteBuffer networkInputBuffer;
    private Pair<Pipe.SinkChannel, Queue<ByteBuffer>> currentStream;
    private int bytesRemaining;
    private final ByteBuffer networkOutputBuffer;
    private final Selector selector;
    private final List<Pipe.SourceChannel> newSourceChannels;
    private final List<Integer> streamsToClose;

    public ChannelMultiplexerThread(CallbackHandler handler, String name, SocketChannel socketChannel) throws IOException {
        super(name);
        this.callback = handler;
        this.socketChannel = socketChannel;
        socketChannel.configureBlocking(false);
        this.sinkChannelByStreamID = Collections.synchronizedMap(new HashMap());
        this.bufferQueueBySinkChannel = Collections.synchronizedMap(new WeakHashMap());
        this.streamIDBySourceChannel = Collections.synchronizedMap(new WeakHashMap());
        this.readQueue = new LinkedList<Pipe.SourceChannel>();
        this.destroyed = false;
        this.bufferPool = new BufferPool();
        this.nextStreamID = new MutableInteger(0);
        this.networkInputBuffer = this.bufferPool.getBuffer();
        this.currentStream = null;
        this.bytesRemaining = 0;
        this.networkOutputBuffer = this.bufferPool.getBuffer();
        this.networkOutputBuffer.clear().flip();
        try {
            this.selector = Selector.open();
        }
        catch (IOException e) {
            throw new InternalError(e);
        }
        this.newSourceChannels = Collections.synchronizedList(new ArrayList());
        this.streamsToClose = Collections.synchronizedList(new ArrayList());
    }

    public void shutdown() {
        this.destroyed = true;
        this.callback.shutdown();
        try {
            this.socketChannel.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.selector.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.socketChannel.register(this.selector, 1);
        }
        catch (ClosedChannelException e) {
            throw new InternalError(e);
        }
        while (!this.destroyed) {
            try {
                List<Pipe.SourceChannel> e = this.newSourceChannels;
                synchronized (e) {
                    for (Pipe.SourceChannel newSource : this.newSourceChannels) {
                        newSource.register(this.selector, 1);
                    }
                    this.newSourceChannels.clear();
                }
                if (!this.streamsToClose.isEmpty()) {
                    this.socketChannel.keyFor(this.selector).interestOps(5);
                }
                this.selector.select();
                Iterator<SelectionKey> keyIt = this.selector.selectedKeys().iterator();
                while (keyIt.hasNext()) {
                    SelectionKey key = keyIt.next();
                    keyIt.remove();
                    if (!key.isValid()) continue;
                    if (key.isReadable()) {
                        ReadableByteChannel source = (ReadableByteChannel)((Object)key.channel());
                        if (source == this.socketChannel) {
                            this.readFromNetwork();
                            continue;
                        }
                        this.readFromPipe((Pipe.SourceChannel)source);
                        continue;
                    }
                    if (!key.isWritable()) continue;
                    WritableByteChannel sink = (WritableByteChannel)((Object)key.channel());
                    if (sink == this.socketChannel) {
                        this.writeToNetwork();
                        continue;
                    }
                    Pipe.SinkChannel sinkChannel = (Pipe.SinkChannel)sink;
                    this.writeToPipe(sinkChannel, this.bufferQueueBySinkChannel.get(sinkChannel));
                }
            }
            catch (IOException e) {
                throw new InternalError(e);
            }
            catch (ClosedSelectorException e) {
                if (this.destroyed) continue;
                throw new InternalError(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToPipe(Pipe.SinkChannel sink, Queue<ByteBuffer> bufferQueue) throws IOException {
        ByteBuffer buffer = bufferQueue.peek();
        sink.write(buffer);
        if (buffer.hasRemaining()) {
            return;
        }
        this.bufferPool.recycle(bufferQueue.remove());
        if (bufferQueue.isEmpty()) {
            Pipe.SinkChannel sinkChannel = sink;
            synchronized (sinkChannel) {
                if (sink.isOpen()) {
                    sink.keyFor(this.selector).interestOps(0);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToNetwork() throws IOException {
        this.socketChannel.write(this.networkOutputBuffer);
        if (this.networkOutputBuffer.hasRemaining()) {
            return;
        }
        List<Integer> list = this.streamsToClose;
        synchronized (list) {
            if (!this.streamsToClose.isEmpty()) {
                this.networkOutputBuffer.clear();
                Iterator<Integer> it = this.streamsToClose.iterator();
                while (it.hasNext() && this.networkOutputBuffer.remaining() >= 8) {
                    this.networkOutputBuffer.putInt(it.next());
                    this.networkOutputBuffer.putInt(-1);
                    it.remove();
                }
                this.networkOutputBuffer.flip();
                return;
            }
        }
        if (!this.readQueue.isEmpty()) {
            Pipe.SourceChannel source = this.readQueue.remove();
            this.readFromPipe(source);
            if (source.isOpen()) {
                source.keyFor(this.selector).interestOps(1);
            }
            return;
        }
        this.socketChannel.keyFor(this.selector).interestOps(1);
    }

    private void readFromPipe(Pipe.SourceChannel source) throws IOException {
        if (this.networkOutputBuffer.hasRemaining()) {
            this.readQueue.add(source);
            source.keyFor(this.selector).interestOps(0);
            return;
        }
        this.networkOutputBuffer.clear();
        this.networkOutputBuffer.putInt(this.getStreamID(source));
        this.networkOutputBuffer.putInt(0);
        int numRead = source.read(this.networkOutputBuffer);
        this.networkOutputBuffer.putInt(4, numRead);
        this.networkOutputBuffer.flip();
        if (numRead == -1) {
            try {
                source.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            SelectionKey key = source.keyFor(this.selector);
            if (key != null) {
                key.cancel();
            }
            this.streamIDBySourceChannel.remove(source);
            this.networkOutputBuffer.clear().flip();
            return;
        }
        this.socketChannel.keyFor(this.selector).interestOps(5);
    }

    private void readFromNetwork() throws IOException {
        if (this.socketChannel.read(this.networkInputBuffer) == -1) {
            this.callback.connectionClosed();
            this.shutdown();
        }
        this.networkInputBuffer.flip();
        while (this.networkInputBuffer.hasRemaining()) {
            ByteBuffer dataBuffer;
            if (this.bytesRemaining == 0) {
                if (this.networkInputBuffer.remaining() < 8) break;
                int streamID = this.networkInputBuffer.getInt();
                this.currentStream = this.getStream(streamID);
                this.bytesRemaining = this.networkInputBuffer.getInt();
                if (this.bytesRemaining != -1) continue;
                this.cleanupStream(streamID);
                this.bytesRemaining = 0;
                continue;
            }
            if (this.networkInputBuffer.remaining() > this.bytesRemaining) {
                byte[] data = new byte[8192];
                this.networkInputBuffer.get(data, 0, this.bytesRemaining);
                dataBuffer = ByteBuffer.wrap(data);
                dataBuffer.limit(this.bytesRemaining);
                this.bytesRemaining = 0;
            } else {
                dataBuffer = this.networkInputBuffer;
                this.networkInputBuffer = this.bufferPool.getBuffer();
                this.networkInputBuffer.clear().flip();
                this.bytesRemaining -= dataBuffer.remaining();
            }
            if (((Queue)this.currentStream.second).isEmpty()) {
                ((Pipe.SinkChannel)this.currentStream.first).register(this.selector, 4);
            }
            ((Queue)this.currentStream.second).add(dataBuffer);
        }
        if (this.networkInputBuffer.hasRemaining()) {
            ByteBuffer oldBuffer = this.networkInputBuffer;
            this.networkInputBuffer = this.bufferPool.getBuffer();
            this.networkInputBuffer.clear();
            this.networkInputBuffer.put(oldBuffer);
        } else {
            this.networkInputBuffer.clear();
        }
    }

    private Pair<Pipe.SinkChannel, Queue<ByteBuffer>> getStream(int streamID) {
        Pair<Pipe.SinkChannel, Queue<ByteBuffer>> result = this.sinkChannelByStreamID.get(streamID);
        if (result == null) {
            this.callback.newStream(this, streamID);
            result = this.sinkChannelByStreamID.get(streamID);
        }
        return result;
    }

    private int getStreamID(ReadableByteChannel channel) {
        return this.streamIDBySourceChannel.get(channel);
    }

    public synchronized void registerChannels(int streamID, Pipe.SourceChannel source, Pipe.SinkChannel sink) throws IOException {
        if (this.sinkChannelByStreamID.containsKey(streamID)) {
            throw new InternalError("Attempting to register a second stream pair at streamID=" + streamID);
        }
        source.configureBlocking(false);
        sink.configureBlocking(false);
        LinkedList bufferQueue = new LinkedList();
        this.sinkChannelByStreamID.put(streamID, new Pair(sink, bufferQueue));
        this.bufferQueueBySinkChannel.put(sink, bufferQueue);
        this.streamIDBySourceChannel.put(source, streamID);
        this.newSourceChannels.add(source);
        this.selector.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int registerChannels(Pipe.SourceChannel source, Pipe.SinkChannel sink) throws IOException {
        int streamID;
        MutableInteger mutableInteger = this.nextStreamID;
        synchronized (mutableInteger) {
            streamID = this.nextStreamID.value++;
        }
        this.registerChannels(streamID, source, sink);
        return streamID;
    }

    void closeStream(int streamID) throws IOException {
        this.streamsToClose.add(streamID);
        this.selector.wakeup();
        this.cleanupStream(streamID);
    }

    private synchronized void cleanupStream(int streamID) throws IOException {
        Pipe.SinkChannel sink = (Pipe.SinkChannel)this.sinkChannelByStreamID.remove((Object)Integer.valueOf((int)streamID)).first;
        this.bufferQueueBySinkChannel.remove(sink);
        sink.close();
    }

    private static class BufferPool {
        private final ByteBuffer[] pool = new ByteBuffer[100];
        private int poolSize = 0;

        BufferPool() {
        }

        ByteBuffer getBuffer() {
            if (this.poolSize == 0) {
                return ByteBuffer.allocate(8192);
            }
            --this.poolSize;
            ByteBuffer result = this.pool[this.poolSize];
            this.pool[this.poolSize] = null;
            return result;
        }

        void recycle(ByteBuffer buffer) {
            if (this.poolSize == this.pool.length) {
                return;
            }
            this.pool[this.poolSize] = buffer;
            ++this.poolSize;
        }
    }

    public static interface CallbackHandler {
        public void newStream(ChannelMultiplexerThread var1, int var2);

        public void connectionClosed();

        public void shutdown();
    }
}

