/*
 * Decompiled with CFR 0.152.
 */
package fabric.messages;

import fabric.common.SerializedObject;
import fabric.common.exceptions.FabricException;
import fabric.common.exceptions.InternalError;
import fabric.common.util.LongKeyHashMap;
import fabric.common.util.LongKeyMap;
import fabric.lang.Object;
import fabric.messages.Message;
import fabric.net.RemoteNode;
import fabric.net.UnreachableNodeException;
import fabric.store.MessageHandlerThread;
import fabric.worker.RemoteStore;
import fabric.worker.debug.Timing;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class UnauthenticatedPrepareTransactionMessage
extends Message<RemoteStore, Response> {
    public final long tid;
    public final long commitTime;
    public final LongKeyMap<Integer> reads;
    public final Collection<Object._Impl> creates;
    public final Collection<SerializedObject> serializedCreates;
    public final Collection<Object._Impl> writes;
    public final Collection<SerializedObject> serializedWrites;

    public UnauthenticatedPrepareTransactionMessage(long tid, long commitTime) {
        this(tid, commitTime, null, null, null);
    }

    public UnauthenticatedPrepareTransactionMessage(long tid, long commitTime, Collection<Object._Impl> toCreate, LongKeyMap<Integer> reads, Collection<Object._Impl> writes) {
        super(Message.MessageType.UNAUTHENTICATED_PREPARE_TRANSACTION);
        this.tid = tid;
        this.commitTime = commitTime;
        this.creates = toCreate;
        this.reads = reads;
        this.writes = writes;
        this.serializedCreates = null;
        this.serializedWrites = null;
    }

    protected UnauthenticatedPrepareTransactionMessage(DataInput in) throws IOException {
        super(Message.MessageType.UNAUTHENTICATED_PREPARE_TRANSACTION);
        int i;
        this.creates = null;
        this.writes = null;
        this.tid = in.readLong();
        this.commitTime = in.readLong();
        int size = in.readInt();
        if (size == 0) {
            this.reads = new LongKeyHashMap<Integer>();
        } else {
            this.reads = new LongKeyHashMap<Integer>(size);
            for (i = 0; i < size; ++i) {
                this.reads.put(in.readLong(), in.readInt());
            }
        }
        size = in.readInt();
        if (size == 0) {
            this.serializedCreates = Collections.emptyList();
        } else {
            this.serializedCreates = new ArrayList<SerializedObject>(size);
            for (i = 0; i < size; ++i) {
                this.serializedCreates.add(new SerializedObject(in));
            }
        }
        size = in.readInt();
        if (size == 0) {
            this.serializedWrites = Collections.emptyList();
        } else {
            this.serializedWrites = new ArrayList<SerializedObject>(size);
            for (i = 0; i < size; ++i) {
                this.serializedWrites.add(new SerializedObject(in));
            }
        }
    }

    @Override
    public Response dispatch(MessageHandlerThread w) {
        return w.handle(this);
    }

    public Response send(RemoteStore store) throws UnreachableNodeException {
        try {
            Timing.STORE.begin();
            Response response = (Response)super.send(store, false);
            return response;
        }
        catch (UnreachableNodeException e) {
            throw e;
        }
        catch (FabricException e) {
            throw new InternalError("Unexpected response from node.", e);
        }
        finally {
            Timing.STORE.end();
        }
    }

    @Override
    public Response response(RemoteStore node, DataInput in) throws IOException {
        return new Response(node, in);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeLong(this.tid);
        out.writeLong(this.commitTime);
        if (this.reads == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.reads.size());
            for (LongKeyMap.Entry<Integer> entry : this.reads.entrySet()) {
                out.writeLong(entry.getKey());
                out.writeInt(entry.getValue());
            }
        }
        if (this.creates == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.creates.size());
            for (Object._Impl impl : this.creates) {
                SerializedObject.write(impl, out);
            }
        }
        if (this.writes == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.writes.size());
            for (Object._Impl impl : this.writes) {
                SerializedObject.write(impl, out);
            }
        }
    }

    public static class Response
    implements Message.Response {
        public final boolean success;
        public final String message;
        public final boolean subTransactionCreated;
        public final LongKeyMap<SerializedObject> versionConflicts;

        public Response() {
            this(false);
        }

        public Response(boolean subTransactionCreated) {
            this.success = true;
            this.subTransactionCreated = subTransactionCreated;
            this.message = null;
            this.versionConflicts = null;
        }

        public Response(String message) {
            this(message, null);
        }

        public Response(String message, LongKeyMap<SerializedObject> versionConflicts) {
            this.success = false;
            this.subTransactionCreated = false;
            this.message = message;
            this.versionConflicts = versionConflicts;
        }

        Response(RemoteNode node, DataInput in) throws IOException {
            this.success = in.readBoolean();
            this.subTransactionCreated = in.readBoolean();
            this.message = in.readBoolean() ? in.readUTF() : null;
            int size = in.readInt();
            this.versionConflicts = new LongKeyHashMap<SerializedObject>(size);
            for (int i = 0; i < size; ++i) {
                SerializedObject obj = new SerializedObject(in);
                this.versionConflicts.put(obj.getOnum(), obj);
            }
        }

        @Override
        public void write(DataOutput out) throws IOException {
            out.writeBoolean(this.success);
            out.writeBoolean(this.subTransactionCreated);
            if (this.message != null) {
                out.writeBoolean(true);
                out.writeUTF(this.message);
            } else {
                out.writeBoolean(false);
            }
            if (this.versionConflicts == null) {
                out.writeInt(0);
            } else {
                out.writeInt(this.versionConflicts.size());
                for (SerializedObject obj : this.versionConflicts.values()) {
                    obj.write(out);
                }
            }
        }
    }
}

