/*
 * Decompiled with CFR 0.152.
 */
package fabric.messages;

import fabric.common.TransactionID;
import fabric.common.exceptions.AccessException;
import fabric.common.exceptions.FabricException;
import fabric.common.exceptions.InternalError;
import fabric.messages.Message;
import fabric.net.RemoteNode;
import fabric.store.MessageHandlerThread;
import fabric.worker.RemoteStore;
import fabric.worker.debug.Timing;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class UnauthenticatedAbortTransactionMessage
extends Message<RemoteStore, Response> {
    public final TransactionID tid;

    public UnauthenticatedAbortTransactionMessage(TransactionID tid) {
        super(Message.MessageType.UNAUTHENTICATED_ABORT_TRANSACTION);
        this.tid = tid;
    }

    protected UnauthenticatedAbortTransactionMessage(DataInput in) throws IOException {
        this(new TransactionID(in));
    }

    @Override
    public Response dispatch(MessageHandlerThread w) throws AccessException {
        w.handle(this);
        return new Response();
    }

    public Response send(RemoteStore store) {
        try {
            Timing.STORE.begin();
            Response response = (Response)this.send(store, true);
            return response;
        }
        catch (FabricException e) {
            throw new InternalError(e);
        }
        finally {
            Timing.STORE.end();
        }
    }

    @Override
    public Response response(RemoteStore store, DataInput in) {
        return new Response(store, in);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        this.tid.write(out);
    }

    public static class Response
    implements Message.Response {
        private Response() {
        }

        Response(RemoteNode node, DataInput in) {
        }

        @Override
        public void write(DataOutput out) {
        }
    }
}

