/*
 * Decompiled with CFR 0.152.
 */
package fabric.messages;

import fabric.common.SerializedObject;
import fabric.common.exceptions.AccessException;
import fabric.common.exceptions.FabricException;
import fabric.common.exceptions.InternalError;
import fabric.common.util.LongKeyHashMap;
import fabric.common.util.LongKeyMap;
import fabric.messages.Message;
import fabric.net.RemoteNode;
import fabric.net.UnreachableNodeException;
import fabric.store.MessageHandlerThread;
import fabric.worker.debug.Timing;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class StalenessCheckMessage
extends Message<RemoteNode, Response> {
    public final LongKeyMap<Integer> versions;

    public StalenessCheckMessage(LongKeyMap<Integer> versions) {
        super(Message.MessageType.STALENESS_CHECK);
        this.versions = versions;
    }

    protected StalenessCheckMessage(DataInput in) throws IOException {
        super(Message.MessageType.STALENESS_CHECK);
        int size = in.readInt();
        this.versions = new LongKeyHashMap<Integer>(size);
        for (int i = 0; i < size; ++i) {
            this.versions.put(in.readLong(), in.readInt());
        }
    }

    @Override
    public Response dispatch(MessageHandlerThread handler) throws AccessException {
        return new Response(handler.handle(this));
    }

    @Override
    public Response response(RemoteNode node, DataInput in) throws IOException {
        return new Response(node, in);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeInt(this.versions.size());
        for (LongKeyMap.Entry<Integer> entry : this.versions.entrySet()) {
            out.writeLong(entry.getKey());
            out.writeInt(entry.getValue());
        }
    }

    public Response send(RemoteNode node) {
        try {
            Timing.STORE.begin();
            Response response = (Response)super.send(node, true);
            return response;
        }
        catch (UnreachableNodeException e) {
            throw e;
        }
        catch (FabricException e) {
            throw new InternalError("Unexpected response from node.", e);
        }
        finally {
            Timing.STORE.end();
        }
    }

    public static class Response
    implements Message.Response {
        public final List<SerializedObject> staleObjects;

        public Response(List<SerializedObject> staleObjects) {
            this.staleObjects = staleObjects;
        }

        Response(RemoteNode node, DataInput in) throws IOException {
            int size = in.readInt();
            this.staleObjects = new ArrayList<SerializedObject>(size);
            for (int i = 0; i < size; ++i) {
                this.staleObjects.add(new SerializedObject(in));
            }
        }

        @Override
        public void write(DataOutput out) throws IOException {
            out.writeInt(this.staleObjects.size());
            for (SerializedObject obj : this.staleObjects) {
                obj.write(out);
            }
        }
    }
}

