/*
 * Decompiled with CFR 0.152.
 */
package fabric.messages;

import fabric.common.ObjectGroup;
import fabric.common.exceptions.AccessException;
import fabric.common.exceptions.FabricException;
import fabric.common.exceptions.FetchException;
import fabric.common.exceptions.InternalError;
import fabric.common.exceptions.ProtocolError;
import fabric.messages.Message;
import fabric.store.MessageHandlerThread;
import fabric.worker.RemoteStore;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class ReadMessage
extends Message<RemoteStore, Response> {
    public final long onum;

    public ReadMessage(long onum) {
        super(Message.MessageType.READ_ONUM);
        this.onum = onum;
    }

    protected ReadMessage(DataInput in) throws IOException {
        this(in.readLong());
    }

    @Override
    public Response dispatch(MessageHandlerThread w) throws AccessException, ProtocolError {
        return w.handle(this);
    }

    public Response send(RemoteStore store) throws FetchException {
        try {
            return (Response)this.send(store, true);
        }
        catch (FetchException e) {
            throw e;
        }
        catch (FabricException e) {
            throw new InternalError("Unexpected response from store.", e);
        }
    }

    @Override
    public Response response(RemoteStore c, DataInput in) throws IOException {
        return new Response(in);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeLong(this.onum);
    }

    public static class Response
    implements Message.Response {
        public final ObjectGroup group;

        public Response(ObjectGroup group) {
            this.group = group;
        }

        Response(DataInput in) throws IOException {
            this.group = in.readBoolean() ? new ObjectGroup(in) : null;
        }

        @Override
        public void write(DataOutput out) throws IOException {
            if (this.group != null) {
                out.writeBoolean(true);
                this.group.write(out);
            } else {
                out.writeBoolean(false);
            }
        }
    }
}

