/*
 * Decompiled with CFR 0.152.
 */
package fabric.messages;

import fabric.common.ObjectGroup;
import fabric.common.exceptions.BadSignatureException;
import fabric.common.exceptions.FabricException;
import fabric.common.exceptions.InternalError;
import fabric.dissemination.Glob;
import fabric.messages.Message;
import fabric.worker.Worker;
import fabric.worker.remote.MessageHandlerThread;
import fabric.worker.remote.RemoteWorker;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.security.PublicKey;

public class ObjectUpdateMessage
extends Message<RemoteWorker, Response> {
    public final String store;
    public final long onum;
    public final Glob glob;
    public final ObjectGroup group;

    private ObjectUpdateMessage(String store, long onum, Glob glob, ObjectGroup group) {
        super(Message.MessageType.OBJECT_UPDATE);
        this.store = store;
        this.onum = onum;
        this.glob = glob;
        this.group = group;
        if (glob == null == (group == null)) {
            throw new InternalError();
        }
    }

    public ObjectUpdateMessage(String store, long onum, Glob update) {
        this(store, onum, update, null);
    }

    public ObjectUpdateMessage(long onum, ObjectGroup update) {
        this(null, onum, null, update);
    }

    protected ObjectUpdateMessage(DataInput in) throws IOException, BadSignatureException {
        super(Message.MessageType.OBJECT_UPDATE);
        this.onum = in.readLong();
        if (in.readBoolean()) {
            this.store = in.readUTF();
            PublicKey key = Worker.getWorker().getStore(this.store).getPublicKey();
            this.glob = new Glob(key, in);
            this.group = null;
        } else {
            this.store = null;
            this.glob = null;
            this.group = new ObjectGroup(in);
        }
    }

    @Override
    public Response dispatch(MessageHandlerThread w) {
        return w.handle(this);
    }

    public Response send(RemoteWorker worker) {
        try {
            boolean encrypt = this.group != null;
            return (Response)this.send(worker, encrypt);
        }
        catch (FabricException e) {
            throw new InternalError("Unexpected response from worker.", e);
        }
    }

    @Override
    public Response response(RemoteWorker node, DataInput in) throws IOException {
        return new Response(node, in);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeLong(this.onum);
        if (this.group == null) {
            out.writeBoolean(true);
            out.writeUTF(this.store);
            this.glob.write(out);
        } else {
            out.writeBoolean(false);
            this.group.write(out);
        }
    }

    public static class Response
    implements Message.Response {
        public final boolean resubscribe;

        public Response(boolean resubscribe) {
            this.resubscribe = resubscribe;
        }

        Response(RemoteWorker node, DataInput in) throws IOException {
            this.resubscribe = in.readBoolean();
        }

        @Override
        public void write(DataOutput out) throws IOException {
            out.writeBoolean(this.resubscribe);
        }
    }
}

