/*
 * Decompiled with CFR 0.152.
 */
package fabric.messages;

import fabric.common.Logging;
import fabric.common.MessageHandler;
import fabric.common.exceptions.FabricException;
import fabric.common.exceptions.FabricRuntimeException;
import fabric.common.exceptions.InternalError;
import fabric.messages.AbortTransactionMessage;
import fabric.messages.AllocateMessage;
import fabric.messages.CommitTransactionMessage;
import fabric.messages.DissemReadMessage;
import fabric.messages.GetCertificateChainMessage;
import fabric.messages.ObjectUpdateMessage;
import fabric.messages.PrepareTransactionMessage;
import fabric.messages.ReadMessage;
import fabric.messages.StalenessCheckMessage;
import fabric.messages.UnauthenticatedAbortTransactionMessage;
import fabric.messages.UnauthenticatedCommitTransactionMessage;
import fabric.messages.UnauthenticatedPrepareTransactionMessage;
import fabric.net.RemoteNode;
import fabric.net.Stream;
import fabric.worker.remote.MessageHandlerThread;
import fabric.worker.remote.messages.GetPrincipalMessage;
import fabric.worker.remote.messages.RemoteCallMessage;
import fabric.worker.remote.messages.TakeOwnershipMessage;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;

public abstract class Message<N extends RemoteNode, R extends Response> {
    protected final MessageType messageType;

    protected Message(MessageType messageType) {
        this.messageType = messageType;
    }

    protected final R send(N node, boolean useSSL) throws FabricException {
        Stream stream = ((RemoteNode)node).openStream(useSSL);
        DataInputStream in = stream.in;
        DataOutputStream out = stream.out;
        try {
            out.writeByte(this.messageType.ordinal());
            this.write(out);
            out.flush();
            Logging.log(Logging.NETWORK_MESSAGE_SEND_LOGGER, Level.FINE, "Sent {0} to {1}", (Object)this.messageType, node);
            if (in.readBoolean()) {
                try {
                    Exception exc = (Exception)Message.readObject(in);
                    exc.fillInStackTrace();
                    Logging.log(Logging.NETWORK_MESSAGE_RECEIVE_LOGGER, Level.FINE, "Received error response for {0} from {1}", (Object)this.messageType, node);
                    if (exc instanceof FabricException) {
                        throw (FabricException)exc;
                    }
                    if (exc instanceof FabricRuntimeException) {
                        throw (FabricRuntimeException)exc;
                    }
                    throw new InternalError("Received unexpected result from " + node, exc);
                }
                catch (ClassNotFoundException e) {
                    throw new InternalError("Unexpected response from remote node", e);
                }
            }
        }
        catch (IOException e) {
            throw new InternalError(e);
        }
        try {
            R e = this.response(node, in);
            return e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalError(e);
        }
        finally {
            Logging.log(Logging.NETWORK_MESSAGE_RECEIVE_LOGGER, Level.FINE, "Received response for {0} from {1}", (Object)this.messageType, node);
            try {
                stream.close();
            }
            catch (IOException e) {
                throw new InternalError(e);
            }
        }
    }

    public static void receive(DataInput in, DataOutputStream out, MessageHandler handler) throws IOException {
        Message m = null;
        try {
            MessageType messageType = MessageType.values()[in.readByte()];
            Class messageClass = messageType.messageClass;
            try {
                m = (Message)messageClass.getDeclaredConstructor(DataInput.class).newInstance(in);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause instanceof IOException) {
                    throw (IOException)cause;
                }
                throw new FabricException(cause);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new FabricException(e);
            }
            Logging.log(Logging.NETWORK_MESSAGE_RECEIVE_LOGGER, Level.FINE, "Received {0}", (Object)m.messageType);
            Object r = m.dispatch(handler);
            out.writeBoolean(false);
            r.write(out);
            out.flush();
            Logging.log(Logging.NETWORK_MESSAGE_SEND_LOGGER, Level.FINE, "Sent response to {0}", (Object)m.messageType);
        }
        catch (FabricException e) {
            e.setStackTrace(new StackTraceElement[0]);
            out.writeBoolean(true);
            Message.writeObject(e, out);
            out.flush();
            if (m != null) {
                Logging.log(Logging.NETWORK_MESSAGE_SEND_LOGGER, Level.FINE, "Sent error response to {0}", (Object)m.messageType);
            }
        }
        catch (FabricRuntimeException e) {
            e.setStackTrace(new StackTraceElement[0]);
            out.writeBoolean(true);
            Message.writeObject(e, out);
            out.flush();
        }
    }

    private static void writeObject(Object o, DataOutputStream out) throws IOException {
        ObjectOutputStream oos = new ObjectOutputStream(out);
        oos.writeObject(o);
        oos.flush();
    }

    private static Object readObject(DataInputStream in) throws IOException, ClassNotFoundException {
        ObjectInputStream ois = new ObjectInputStream(in);
        return ois.readObject();
    }

    private final R dispatch(MessageHandler handler) throws FabricException {
        if (handler instanceof MessageHandlerThread) {
            return this.dispatch((MessageHandlerThread)handler);
        }
        return this.dispatch((fabric.store.MessageHandlerThread)handler);
    }

    public R dispatch(fabric.store.MessageHandlerThread handler) throws FabricException {
        throw new InternalError("Invalid, unsupported, or unimplemented store message: " + this.getClass());
    }

    public R dispatch(MessageHandlerThread handler) throws FabricException {
        throw new InternalError("Invalid, unsupported, or unimplemented worker message: " + this.getClass());
    }

    public abstract R response(N var1, DataInput var2) throws IOException, FabricException;

    public abstract void write(DataOutput var1) throws IOException;

    protected static enum MessageType {
        ALLOCATE_ONUMS(AllocateMessage.class),
        READ_ONUM(ReadMessage.class),
        PREPARE_TRANSACTION(PrepareTransactionMessage.class),
        COMMIT_TRANSACTION(CommitTransactionMessage.class),
        ABORT_TRANSACTION(AbortTransactionMessage.class),
        DISSEM_READ_ONUM(DissemReadMessage.class),
        REMOTE_CALL(RemoteCallMessage.class),
        INTERWORKER_READ(fabric.worker.remote.messages.ReadMessage.class),
        TAKE_OWNERSHIP(TakeOwnershipMessage.class),
        GET_PRINCIPAL(GetPrincipalMessage.class),
        OBJECT_UPDATE(ObjectUpdateMessage.class),
        UNAUTHENTICATED_PREPARE_TRANSACTION(UnauthenticatedPrepareTransactionMessage.class),
        UNAUTHENTICATED_COMMIT_TRANSACTION(UnauthenticatedCommitTransactionMessage.class),
        UNAUTHENTICATED_ABORT_TRANSACTION(UnauthenticatedAbortTransactionMessage.class),
        GET_CERT_CHAIN(GetCertificateChainMessage.class),
        STALENESS_CHECK(StalenessCheckMessage.class),
        INTERWORKER_STALENESS_CHECK(fabric.worker.remote.messages.StalenessCheckMessage.class);

        private final Class<? extends Message<?, ?>> messageClass;

        private MessageType(Class<? extends Message<?, ?>> messageClass) {
            this.messageClass = messageClass;
        }
    }

    public static interface Response {
        public void write(DataOutput var1) throws IOException;
    }
}

