/*
 * Decompiled with CFR 0.152.
 */
package fabric.messages;

import fabric.common.Util;
import fabric.common.exceptions.FabricException;
import fabric.common.exceptions.InternalError;
import fabric.messages.Message;
import fabric.net.RemoteNode;
import fabric.net.UnreachableNodeException;
import fabric.store.MessageHandlerThread;
import fabric.worker.RemoteStore;
import fabric.worker.debug.Timing;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.security.cert.Certificate;

public class GetCertificateChainMessage
extends Message<RemoteStore, Response> {
    public GetCertificateChainMessage() {
        super(Message.MessageType.GET_CERT_CHAIN);
    }

    protected GetCertificateChainMessage(DataInput in) {
        this();
    }

    @Override
    public Response dispatch(MessageHandlerThread w) {
        return w.handle(this);
    }

    public Response send(RemoteStore store) throws UnreachableNodeException {
        try {
            Timing.STORE.begin();
            Response response = (Response)this.send(store, false);
            return response;
        }
        catch (UnreachableNodeException e) {
            throw e;
        }
        catch (FabricException e) {
            throw new InternalError("Unexpected response from store.", e);
        }
        finally {
            Timing.STORE.end();
        }
    }

    @Override
    public Response response(RemoteStore node, DataInput in) throws IOException {
        return new Response(node, in);
    }

    @Override
    public void write(DataOutput out) {
    }

    public static class Response
    implements Message.Response {
        public final Certificate[] certificateChain;

        public Response(Certificate[] certificateChain) {
            this.certificateChain = certificateChain;
        }

        Response(RemoteNode node, DataInput in) throws IOException {
            Certificate[] certificateChain;
            byte[] buf = new byte[in.readInt()];
            in.readFully(buf);
            ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(buf));
            try {
                certificateChain = (Certificate[])ois.readObject();
            }
            catch (ClassNotFoundException e) {
                certificateChain = null;
            }
            this.certificateChain = certificateChain;
        }

        @Override
        public void write(DataOutput out) throws IOException {
            byte[] buf = Util.serialize(this.certificateChain);
            out.writeInt(buf.length);
            out.write(buf);
        }
    }
}

