/*
 * Decompiled with CFR 0.152.
 */
package fabric.messages;

import fabric.common.exceptions.AccessException;
import fabric.common.exceptions.BadSignatureException;
import fabric.common.exceptions.FabricException;
import fabric.common.exceptions.FetchException;
import fabric.common.exceptions.InternalError;
import fabric.dissemination.Glob;
import fabric.messages.Message;
import fabric.store.MessageHandlerThread;
import fabric.worker.RemoteStore;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class DissemReadMessage
extends Message<RemoteStore, Response> {
    public final long onum;

    public DissemReadMessage(long onum) {
        super(Message.MessageType.DISSEM_READ_ONUM);
        this.onum = onum;
    }

    protected DissemReadMessage(DataInput in) throws IOException {
        this(in.readLong());
    }

    @Override
    public Response dispatch(MessageHandlerThread w) throws AccessException {
        return w.handle(this);
    }

    public Response send(RemoteStore store) throws FetchException {
        try {
            return (Response)this.send(store, false);
        }
        catch (FetchException e) {
            throw e;
        }
        catch (FabricException e) {
            throw new InternalError("Unexpected response from store.", e);
        }
    }

    @Override
    public Response response(RemoteStore c, DataInput in) throws IOException {
        return new Response(c, in);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeLong(this.onum);
    }

    public static class Response
    implements Message.Response {
        public final Glob glob;

        public Response(Glob glob) {
            this.glob = glob;
        }

        Response(RemoteStore store, DataInput in) throws IOException {
            Glob glob;
            try {
                glob = new Glob(store.getPublicKey(), in);
            }
            catch (BadSignatureException e) {
                glob = null;
            }
            this.glob = glob;
        }

        @Override
        public void write(DataOutput out) throws IOException {
            this.glob.write(out);
        }
    }
}

