/*
 * Decompiled with CFR 0.152.
 */
package fabric.messages;

import fabric.common.exceptions.FabricException;
import fabric.common.exceptions.InternalError;
import fabric.common.exceptions.ProtocolError;
import fabric.messages.Message;
import fabric.net.RemoteNode;
import fabric.net.UnreachableNodeException;
import fabric.worker.debug.Timing;
import fabric.worker.remote.MessageHandlerThread;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class CommitTransactionMessage
extends Message<RemoteNode, Response> {
    public final long transactionID;

    public CommitTransactionMessage(long transactionID) {
        super(Message.MessageType.COMMIT_TRANSACTION);
        this.transactionID = transactionID;
    }

    protected CommitTransactionMessage(DataInput in) throws IOException {
        this(in.readLong());
    }

    @Override
    public Response dispatch(fabric.store.MessageHandlerThread w) throws ProtocolError {
        return w.handle(this);
    }

    @Override
    public Response dispatch(MessageHandlerThread handler) throws ProtocolError {
        return handler.handle(this);
    }

    public Response send(RemoteNode node) throws UnreachableNodeException {
        try {
            Timing.STORE.begin();
            Response response = (Response)super.send(node, true);
            return response;
        }
        catch (UnreachableNodeException e) {
            throw e;
        }
        catch (FabricException e) {
            throw new InternalError("Unexpected response from node.", e);
        }
        finally {
            Timing.STORE.end();
        }
    }

    @Override
    public Response response(RemoteNode node, DataInput in) throws IOException {
        return new Response(node, in);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeLong(this.transactionID);
    }

    public static class Response
    implements Message.Response {
        public final boolean success;
        public final String message;

        public Response(boolean success) {
            this(success, null);
        }

        public Response(boolean success, String message) {
            this.success = success;
            this.message = message;
        }

        Response(RemoteNode node, DataInput in) throws IOException {
            this.success = in.readBoolean();
            this.message = in.readBoolean() ? in.readUTF() : null;
        }

        @Override
        public void write(DataOutput out) throws IOException {
            out.writeBoolean(this.success);
            if (this.message != null) {
                out.writeBoolean(true);
                out.writeUTF(this.message);
            } else {
                out.writeBoolean(false);
            }
        }
    }
}

