/*
 * Decompiled with CFR 0.152.
 */
package fabric.messages;

import fabric.common.exceptions.AccessException;
import fabric.common.exceptions.FabricException;
import fabric.common.exceptions.InternalError;
import fabric.common.exceptions.ProtocolError;
import fabric.messages.Message;
import fabric.net.UnreachableNodeException;
import fabric.store.MessageHandlerThread;
import fabric.worker.RemoteStore;
import fabric.worker.Store;
import fabric.worker.debug.Timing;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class AllocateMessage
extends Message<RemoteStore, Response> {
    public final int num;

    public AllocateMessage(int num) {
        super(Message.MessageType.ALLOCATE_ONUMS);
        this.num = num;
    }

    protected AllocateMessage(DataInput in) throws IOException {
        this(in.readInt());
    }

    @Override
    public Response dispatch(MessageHandlerThread w) throws AccessException, ProtocolError {
        return w.handle(this);
    }

    public Response send(RemoteStore store) throws UnreachableNodeException {
        try {
            Timing.STORE.begin();
            Response response = (Response)this.send(store, true);
            return response;
        }
        catch (UnreachableNodeException e) {
            throw e;
        }
        catch (FabricException e) {
            throw new InternalError("Unexpected response from store.", e);
        }
        finally {
            Timing.STORE.end();
        }
    }

    @Override
    public Response response(RemoteStore c, DataInput in) throws IOException {
        return new Response(c, in);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeInt(this.num);
    }

    public static class Response
    implements Message.Response {
        public long[] oids;

        public Response(long[] onums) {
            this.oids = onums;
        }

        Response(Store store, DataInput in) throws IOException {
            this.oids = new long[in.readInt()];
            for (int i = 0; i < this.oids.length; ++i) {
                this.oids[i] = in.readLong();
            }
        }

        @Override
        public void write(DataOutput out) throws IOException {
            out.writeInt(this.oids.length);
            for (long oid : this.oids) {
                out.writeLong(oid);
            }
        }
    }
}

