/*
 * Decompiled with CFR 0.152.
 */
package fabric.messages;

import fabric.common.TransactionID;
import fabric.common.exceptions.AccessException;
import fabric.common.exceptions.FabricException;
import fabric.common.exceptions.InternalError;
import fabric.common.exceptions.ProtocolError;
import fabric.messages.Message;
import fabric.net.RemoteNode;
import fabric.worker.debug.Timing;
import fabric.worker.remote.MessageHandlerThread;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class AbortTransactionMessage
extends Message<RemoteNode, Response> {
    public final TransactionID tid;

    public AbortTransactionMessage(TransactionID tid) {
        super(Message.MessageType.ABORT_TRANSACTION);
        this.tid = tid;
    }

    protected AbortTransactionMessage(DataInput in) throws IOException {
        this(new TransactionID(in));
    }

    @Override
    public Response dispatch(fabric.store.MessageHandlerThread w) throws AccessException, ProtocolError {
        w.handle(this);
        return new Response();
    }

    @Override
    public Response dispatch(MessageHandlerThread handler) throws ProtocolError {
        handler.handle(this);
        return new Response();
    }

    public Response send(RemoteNode node) {
        try {
            Timing.STORE.begin();
            Response response = (Response)this.send(node, true);
            return response;
        }
        catch (FabricException e) {
            throw new InternalError(e);
        }
        finally {
            Timing.STORE.end();
        }
    }

    @Override
    public Response response(RemoteNode node, DataInput in) {
        return new Response(node, in);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        this.tid.write(out);
    }

    public static class Response
    implements Message.Response {
        private Response() {
        }

        Response(RemoteNode node, DataInput in) {
        }

        @Override
        public void write(DataOutput out) {
        }
    }
}

