/*
 * Decompiled with CFR 0.152.
 */
package fabric.lang.security;

import fabric.lang.security.ActsForProof;
import fabric.lang.security.Label;
import fabric.lang.security.Principal;
import fabric.lang.security.PrincipalUtil;
import fabric.worker.transaction.AbstractSecurityCache;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class SecurityCache
extends AbstractSecurityCache {
    private final SecurityCache parent;
    private Map<ActsForPair, ActsForProof> actsFor;
    private Set<ActsForPair> notActsFor;
    private Map<DelegationPair, Set<ActsForPair>> actsForDependencies;
    private Set<Pair> trueLabelRelabels;
    private Set<Pair> falseLabelRelabels;
    private Map<DelegationPair, Set<Pair>> trueLabelRelabelsDependencies;
    private Map<Pair, Set<DelegationPair>> truePolicyRelabels;
    private Set<Pair> falsePolicyRelabels;
    private Map<DelegationPair, Set<Pair>> truePolicyRelabelsDependencies;
    private Map<Pair, Label> labelJoins;
    private Map<Pair, Label> labelMeets;
    private Map<DelegationPair, Set<Pair>> labelJoinDependencies;
    private Map<DelegationPair, Set<Pair>> labelMeetDependencies;

    public SecurityCache(SecurityCache parent) {
        this.parent = parent;
        if (parent == null) {
            this.actsFor = new HashMap<ActsForPair, ActsForProof>();
            this.notActsFor = new HashSet<ActsForPair>();
            this.actsForDependencies = new HashMap<DelegationPair, Set<ActsForPair>>();
            this.trueLabelRelabels = new HashSet<Pair>();
            this.falseLabelRelabels = new HashSet<Pair>();
            this.trueLabelRelabelsDependencies = new HashMap<DelegationPair, Set<Pair>>();
            this.truePolicyRelabels = new HashMap<Pair, Set<DelegationPair>>();
            this.falsePolicyRelabels = new HashSet<Pair>();
            this.truePolicyRelabelsDependencies = new HashMap<DelegationPair, Set<Pair>>();
            this.labelJoins = new HashMap<Pair, Label>();
            this.labelMeets = new HashMap<Pair, Label>();
            this.labelJoinDependencies = new HashMap<DelegationPair, Set<Pair>>();
            this.labelMeetDependencies = new HashMap<DelegationPair, Set<Pair>>();
            return;
        }
        this.actsFor = new HashMap<ActsForPair, ActsForProof>(parent.actsFor);
        this.notActsFor = new HashSet<ActsForPair>(parent.notActsFor);
        this.actsForDependencies = new HashMap<DelegationPair, Set<ActsForPair>>(parent.actsForDependencies);
        this.trueLabelRelabels = new HashSet<Pair>(parent.trueLabelRelabels);
        this.falseLabelRelabels = new HashSet<Pair>(parent.falseLabelRelabels);
        this.trueLabelRelabelsDependencies = new HashMap<DelegationPair, Set<Pair>>(parent.trueLabelRelabelsDependencies);
        this.truePolicyRelabels = new HashMap<Pair, Set<DelegationPair>>(parent.truePolicyRelabels);
        this.falsePolicyRelabels = new HashSet<Pair>(parent.falsePolicyRelabels);
        this.truePolicyRelabelsDependencies = new HashMap<DelegationPair, Set<Pair>>(parent.truePolicyRelabelsDependencies);
        this.labelJoins = new HashMap<Pair, Label>(parent.labelJoins);
        this.labelMeets = new HashMap<Pair, Label>(parent.labelMeets);
        this.labelJoinDependencies = new HashMap<DelegationPair, Set<Pair>>(parent.labelJoinDependencies);
        this.labelMeetDependencies = new HashMap<DelegationPair, Set<Pair>>(parent.labelMeetDependencies);
    }

    @Override
    protected void reset() {
        this.actsFor.clear();
        this.notActsFor.clear();
        this.actsForDependencies.clear();
        this.trueLabelRelabels.clear();
        this.falseLabelRelabels.clear();
        this.trueLabelRelabelsDependencies.clear();
        this.truePolicyRelabels.clear();
        this.falsePolicyRelabels.clear();
        this.truePolicyRelabelsDependencies.clear();
        this.labelJoins.clear();
        this.labelMeets.clear();
        this.labelJoinDependencies.clear();
        this.labelMeetDependencies.clear();
        if (this.parent != null) {
            this.actsFor.putAll(this.parent.actsFor);
            this.notActsFor.addAll(this.parent.notActsFor);
            this.actsForDependencies.putAll(this.parent.actsForDependencies);
            this.trueLabelRelabels.addAll(this.parent.trueLabelRelabels);
            this.falseLabelRelabels.addAll(this.parent.falseLabelRelabels);
            this.trueLabelRelabelsDependencies.putAll(this.parent.trueLabelRelabelsDependencies);
            this.truePolicyRelabels.putAll(this.parent.truePolicyRelabels);
            this.falsePolicyRelabels.addAll(this.parent.falsePolicyRelabels);
            this.truePolicyRelabelsDependencies.putAll(this.parent.truePolicyRelabelsDependencies);
            this.labelJoins.putAll(this.parent.labelJoins);
            this.labelMeets.putAll(this.parent.labelMeets);
            this.labelJoinDependencies.putAll(this.parent.labelJoinDependencies);
            this.labelMeetDependencies.putAll(this.parent.labelMeetDependencies);
        }
    }

    @Override
    protected void set(SecurityCache cache) {
        this.actsFor = cache.actsFor;
        this.notActsFor = cache.notActsFor;
        this.actsForDependencies = cache.actsForDependencies;
        this.trueLabelRelabels = cache.trueLabelRelabels;
        this.falseLabelRelabels = cache.falseLabelRelabels;
        this.trueLabelRelabelsDependencies = cache.trueLabelRelabelsDependencies;
        this.truePolicyRelabels = cache.truePolicyRelabels;
        this.falsePolicyRelabels = cache.falsePolicyRelabels;
        this.truePolicyRelabelsDependencies = cache.truePolicyRelabelsDependencies;
        this.labelJoins = cache.labelJoins;
        this.labelMeets = cache.labelMeets;
        this.labelJoinDependencies = cache.labelJoinDependencies;
        this.labelMeetDependencies = cache.labelMeetDependencies;
    }

    boolean containsActsFor(ActsForPair pair) {
        return this.actsFor.containsKey(pair);
    }

    ActsForProof getActsFor(ActsForPair pair) {
        return this.actsFor.get(pair);
    }

    void putActsFor(ActsForPair pair, ActsForProof proof) {
        this.actsFor.put(pair, proof);
    }

    void removeActsFor(ActsForPair pair) {
        this.actsFor.remove(pair);
    }

    boolean containsNotActsFor(ActsForPair pair) {
        return this.notActsFor.contains(pair);
    }

    void addNotActsFor(ActsForPair pair) {
        this.notActsFor.add(pair);
    }

    void clearNotActsFor() {
        this.notActsFor.clear();
    }

    void addActsForDependency(DelegationPair del, ActsForPair pair) {
        Set<ActsForPair> set = this.actsForDependencies.get(del);
        if (set == null) {
            set = new HashSet<ActsForPair>();
            this.actsForDependencies.put(del, set);
        }
        set.add(pair);
    }

    Set<ActsForPair> getActsForDependencies(DelegationPair pair) {
        return this.actsForDependencies.get(pair);
    }

    Set<ActsForPair> removeActsForDependencies(DelegationPair pair) {
        return this.actsForDependencies.remove(pair);
    }

    boolean containsTrueLabelRelabel(Pair pair) {
        return this.trueLabelRelabels.contains(pair);
    }

    void addTrueLabelRelabel(Pair pair) {
        this.trueLabelRelabels.add(pair);
    }

    void removeTrueLabelRelabel(Pair pair) {
        this.trueLabelRelabels.remove(pair);
    }

    boolean containsFalseLabelRelabel(Pair pair) {
        return this.falseLabelRelabels.contains(pair);
    }

    void addFalseLabelRelabel(Pair pair) {
        this.falseLabelRelabels.add(pair);
    }

    void clearFalseLabelRelabels() {
        this.falseLabelRelabels.clear();
    }

    void addTrueLabelRelabelsDependency(DelegationPair del, Pair pair) {
        Set<Pair> set = this.trueLabelRelabelsDependencies.get(del);
        if (set == null) {
            set = new HashSet<Pair>();
            this.trueLabelRelabelsDependencies.put(del, set);
        }
        set.add(pair);
    }

    Set<Pair> removeTrueLabelRelabelsDependencies(DelegationPair pair) {
        return this.trueLabelRelabelsDependencies.remove(pair);
    }

    boolean containsTruePolicyRelabel(Pair pair) {
        return this.truePolicyRelabels.containsKey(pair);
    }

    Set<DelegationPair> getTruePolicyRelabels(Pair pair) {
        return this.truePolicyRelabels.get(pair);
    }

    void putTruePolicyRelabels(Pair pair, Set<DelegationPair> deps) {
        this.truePolicyRelabels.put(pair, deps);
    }

    void removeTruePolicyRelabel(Pair pair) {
        this.truePolicyRelabels.remove(pair);
    }

    boolean containsFalsePolicyRelabel(Pair pair) {
        return this.falsePolicyRelabels.contains(pair);
    }

    void addFalsePolicyRelabel(Pair pair) {
        this.falsePolicyRelabels.add(pair);
    }

    void clearFalsePolicyRelabels() {
        this.falsePolicyRelabels.clear();
    }

    void addTruePolicyRelabelsDependency(DelegationPair del, Pair pair) {
        Set<Pair> set = this.truePolicyRelabelsDependencies.get(del);
        if (set == null) {
            set = new HashSet<Pair>();
            this.truePolicyRelabelsDependencies.put(del, set);
        }
        set.add(pair);
    }

    Set<Pair> removeTruePolicyRelabelsDependencies(DelegationPair pair) {
        return this.truePolicyRelabelsDependencies.remove(pair);
    }

    Label getLabelJoin(Pair pair) {
        return this.labelJoins.get(pair);
    }

    void putLabelJoin(Pair pair, Label label) {
        this.labelJoins.put(pair, label);
    }

    void clearLabelJoins() {
        this.labelJoins.clear();
    }

    void removeLabelJoin(Pair pair) {
        this.labelJoins.remove(pair);
    }

    Label getLabelMeet(Pair pair) {
        return this.labelMeets.get(pair);
    }

    void putLabelMeet(Pair pair, Label label) {
        this.labelMeets.put(pair, label);
    }

    void clearLabelMeets() {
        this.labelMeets.clear();
    }

    void removeLabelMeet(Pair pair) {
        this.labelMeets.remove(pair);
    }

    void addLabelJoinDependency(DelegationPair del, Pair pair) {
        Set<Pair> set = this.labelJoinDependencies.get(del);
        if (set == null) {
            set = new HashSet<Pair>();
            this.labelJoinDependencies.put(del, set);
        }
        set.add(pair);
    }

    void clearLabelJoinDependencies() {
        this.labelJoinDependencies.clear();
    }

    Set<Pair> removeLabelJoinDependencies(DelegationPair pair) {
        return this.labelJoinDependencies.remove(pair);
    }

    void addLabelMeetDependency(DelegationPair del, Pair pair) {
        Set<Pair> set = this.labelMeetDependencies.get(del);
        if (set == null) {
            set = new HashSet<Pair>();
            this.labelMeetDependencies.put(del, set);
        }
        set.add(pair);
    }

    void clearLabelMeetDependencies() {
        this.labelMeetDependencies.clear();
    }

    Set<Pair> removeLabelMeetDependencies(DelegationPair pair) {
        return this.labelMeetDependencies.remove(pair);
    }

    static class Pair {
        final Object left;
        final Object right;

        public Pair(Object left, Object right) {
            this.left = left;
            this.right = right;
        }

        public int hashCode() {
            return this.left.hashCode() ^ this.right.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof Pair) {
                Pair that = (Pair)o;
                return !(this.left != that.left && !this.left.equals(that.left) || this.right != that.right && !this.right.equals(that.right));
            }
            return false;
        }

        public String toString() {
            return this.left + "-" + this.right;
        }
    }

    static class DelegationPair
    extends PrincipalPair {
        DelegationPair(Principal superior, Principal inferior) {
            super(superior, inferior);
        }
    }

    static class ActsForPair
    extends PrincipalPair {
        ActsForPair(Principal superior, Principal inferior) {
            super(superior, inferior);
        }
    }

    static abstract class PrincipalPair {
        final Principal p;
        final Principal q;

        PrincipalPair(Principal p, Principal q) {
            this.p = p;
            this.q = q;
        }

        public boolean equals(Object o) {
            if (o == null || !o.getClass().equals(this.getClass())) {
                return false;
            }
            PrincipalPair that = (PrincipalPair)o;
            return PrincipalUtil._Impl.equals((Principal)this.p, (Principal)that.p) && PrincipalUtil._Impl.equals((Principal)this.q, (Principal)that.q);
        }

        public int hashCode() {
            return (this.p == null ? -4234 : this.p.hashCode()) ^ (this.q == null ? 23 : this.q.hashCode());
        }

        public String toString() {
            return this.p.name() + "-" + this.q.name();
        }
    }
}

