/*
 * Decompiled with CFR 0.152.
 */
package fabric.lang.security;

import fabric.common.Crypto;
import fabric.common.RefTypeEnum;
import fabric.common.util.Pair;
import fabric.lang.Object;
import fabric.lang.security.ActsForProof;
import fabric.lang.security.Closure;
import fabric.lang.security.ConfPolicy;
import fabric.lang.security.IntegPolicy;
import fabric.lang.security.Label;
import fabric.lang.security.LabelUtil;
import fabric.lang.security.PrincipalUtil;
import fabric.lang.security.PrivateKeyObject;
import fabric.net.UnreachableNodeException;
import fabric.worker.Store;
import fabric.worker.Worker;
import fabric.worker.transaction.TransactionManager;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.security.KeyPair;
import java.security.PublicKey;
import java.util.Iterator;
import java.util.List;

public interface Principal
extends Object {
    public String name();

    public boolean delegatesTo(Principal var1);

    public boolean equals(Principal var1);

    public boolean isAuthorized(java.lang.Object var1, Closure var2, Label var3, boolean var4);

    public ActsForProof findProofUpto(Store var1, Principal var2, java.lang.Object var3);

    public ActsForProof findProofDownto(Store var1, Principal var2, java.lang.Object var3);

    public PublicKey getPublicKey();

    public PrivateKeyObject getPrivateKeyObject();

    public static interface _Static
    extends Object,
    Cloneable {

        public static class _Impl
        extends Object._Impl
        implements _Static {
            public _Impl(Store store, Label label) throws UnreachableNodeException {
                super(store, label);
            }

            @Override
            protected Object._Proxy $makeProxy() {
                return new _Proxy(this);
            }

            private void $init() {
            }
        }

        public static final class _Proxy
        extends Object._Proxy
        implements _Static {
            public static final _Static $instance;

            public _Proxy(_Impl impl) {
                super(impl);
            }

            public _Proxy(Store store, long onum) {
                super(store, onum);
            }

            static {
                _Impl impl = (_Impl)Object._Static._Proxy.$makeStaticInstance(_Impl.class);
                $instance = (_Static)((java.lang.Object)impl.$getProxy());
                impl.$init();
            }
        }
    }

    public static abstract class _Impl
    extends Object._Impl
    implements Principal {
        private PublicKey publicKey;
        private PrivateKeyObject privateKeyObject;

        public _Impl(Store store, Label label) {
            super(store, label == null ? Worker.getWorker().getLocalStore().getPublicReadonlyLabel() : label);
            _Proxy thisProxy = (_Proxy)this.$getProxy();
            IntegPolicy integ = LabelUtil._Impl.writerPolicy((Store)store, (Principal)thisProxy, (Principal)thisProxy);
            if (!(this instanceof PrincipalUtil.TopPrincipal)) {
                ConfPolicy bottomConf = Worker.getWorker().getLocalStore().getBottomConfidPolicy();
                Label thisIntegLabel = LabelUtil._Impl.toLabel((Store)store, (ConfPolicy)bottomConf, (IntegPolicy)integ);
                this.$label = label == null ? thisIntegLabel : LabelUtil._Impl.join((Store)this.$label.$getStore(), (Label)this.$label, (Label)thisIntegLabel);
            }
            KeyPair keyPair = Crypto.genKeyPair();
            this.publicKey = keyPair.getPublic();
            ConfPolicy conf = LabelUtil._Impl.readerPolicy((Store)store, (Principal)thisProxy, (Principal)thisProxy);
            Label privateLabel = LabelUtil._Impl.toLabel((Store)store, (ConfPolicy)conf, (IntegPolicy)integ);
            this.privateKeyObject = new PrivateKeyObject._Impl(store, privateLabel, keyPair.getPrivate());
        }

        @Override
        public abstract String name();

        @Override
        public abstract boolean delegatesTo(Principal var1);

        @Override
        public abstract boolean equals(Principal var1);

        @Override
        public abstract boolean isAuthorized(java.lang.Object var1, Closure var2, Label var3, boolean var4);

        @Override
        public abstract ActsForProof findProofUpto(Store var1, Principal var2, java.lang.Object var3);

        @Override
        public abstract ActsForProof findProofDownto(Store var1, Principal var2, java.lang.Object var3);

        @Override
        protected Object._Proxy $makeProxy() {
            return new _Proxy(this);
        }

        @Override
        public void $serialize(ObjectOutput out, List<RefTypeEnum> refTypes, List<Long> intraStoreRefs, List<Pair<String, Long>> interStoreRefs) throws IOException {
            super.$serialize(out, refTypes, intraStoreRefs, interStoreRefs);
        }

        public _Impl(Store store, long onum, int version, long expiry, long label, ObjectInput in, Iterator<RefTypeEnum> refTypes, Iterator<Long> intraStoreRefs) throws IOException, ClassNotFoundException {
            super(store, onum, version, expiry, label, in, refTypes, intraStoreRefs);
        }

        @Override
        public final PublicKey getPublicKey() {
            TransactionManager.getInstance().registerRead(this);
            return this.publicKey;
        }

        @Override
        public final PrivateKeyObject getPrivateKeyObject() {
            TransactionManager.getInstance().registerRead(this);
            return this.privateKeyObject;
        }
    }

    public static class _Proxy
    extends Object._Proxy
    implements Principal {
        public _Proxy(_Impl impl) {
            super(impl);
        }

        public _Proxy(Store store, long onum) {
            super(store, onum);
        }

        @Override
        public String name() {
            return ((Principal)((java.lang.Object)this.fetch())).name();
        }

        @Override
        public boolean delegatesTo(Principal p) {
            return ((Principal)((java.lang.Object)this.fetch())).delegatesTo(p);
        }

        @Override
        public boolean equals(Principal p) {
            return ((Principal)((java.lang.Object)this.fetch())).equals(p);
        }

        @Override
        public boolean isAuthorized(java.lang.Object authPrf, Closure closure, Label lb, boolean executeNow) {
            return ((Principal)((java.lang.Object)this.fetch())).isAuthorized(authPrf, closure, lb, executeNow);
        }

        @Override
        public ActsForProof findProofUpto(Store store, Principal p, java.lang.Object searchState) {
            return ((Principal)((java.lang.Object)this.fetch())).findProofUpto(store, p, searchState);
        }

        @Override
        public ActsForProof findProofDownto(Store store, Principal q, java.lang.Object searchState) {
            return ((Principal)((java.lang.Object)this.fetch())).findProofDownto(store, q, searchState);
        }

        @Override
        public PublicKey getPublicKey() {
            return ((Principal)((java.lang.Object)this.fetch())).getPublicKey();
        }

        @Override
        public PrivateKeyObject getPrivateKeyObject() {
            return ((Principal)((java.lang.Object)this.fetch())).getPrivateKeyObject();
        }
    }
}

