/*
 * Decompiled with CFR 0.152.
 */
package fabric.lang.arrays.internal;

import fabric.common.RefTypeEnum;
import fabric.common.exceptions.InternalError;
import fabric.common.util.Pair;
import fabric.lang.Object;
import fabric.lang.arrays.internal._InternalArrayImpl;
import fabric.lang.security.Label;
import fabric.worker.Store;
import fabric.worker.transaction.TransactionManager;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public interface _ObjectArray<T extends Object>
extends Object {
    public int get$length();

    public T set(int var1, T var2);

    public T get(int var1);

    public static class _Proxy<T extends Object>
    extends Object._Proxy
    implements _ObjectArray<T> {
        public _Proxy(Store store, long onum) {
            super(store, onum);
        }

        public _Proxy(_Impl<T> impl) {
            super(impl);
        }

        @Override
        public int get$length() {
            return ((_ObjectArray)((java.lang.Object)this.fetch())).get$length();
        }

        @Override
        public T get(int i) {
            return ((_ObjectArray)((java.lang.Object)this.fetch())).get(i);
        }

        @Override
        public T set(int i, T value) {
            return ((_ObjectArray)((java.lang.Object)this.fetch())).set(i, value);
        }
    }

    public static class _Impl<T extends Object>
    extends Object._Impl
    implements _ObjectArray<T>,
    _InternalArrayImpl {
        private final Class<? extends Object._Proxy> proxyType;
        private Object[] value;
        private static final Map<Class<?>, Class<? extends Object._Proxy>> proxyCache = Collections.synchronizedMap(new HashMap());

        public _Impl(Store store, Label label, Class<? extends Object._Proxy> proxyType, int length) {
            super(store, label);
            this.proxyType = this.getProxy(proxyType);
            this.value = new Object[length];
        }

        public _Impl(Store store, Label label, Class<? extends Object._Proxy> proxyType, T[] value) {
            super(store, label);
            this.proxyType = this.getProxy(proxyType);
            this.value = value;
        }

        public _Impl(Store store, long onum, int version, long expiry, long label, ObjectInput in, Iterator<RefTypeEnum> refTypes, Iterator<Long> intraStoreRefs) throws IOException, ClassNotFoundException {
            super(store, onum, version, expiry, label, in, refTypes, intraStoreRefs);
            this.proxyType = Class.forName(in.readUTF());
            this.value = new Object[in.readInt()];
            for (int i = 0; i < this.value.length; ++i) {
                this.value[i] = _Impl.$readRef(this.proxyType, refTypes.next(), in, store, intraStoreRefs);
            }
        }

        private Class<? extends Object._Proxy> getProxy(Class<?> c) {
            Class<?>[] classes;
            Class<Object._Proxy> result = proxyCache.get(c);
            if (result != null) {
                return result;
            }
            if (c.getSimpleName().equals("_Proxy")) {
                result = c;
                proxyCache.put(c, result);
                return result;
            }
            for (Class<?> c_ : classes = c.getClasses()) {
                if (!c_.getSimpleName().equals("_Proxy")) continue;
                result = c_;
                proxyCache.put(c, result);
                return result;
            }
            throw new InternalError("Error finding _Proxy class in " + c);
        }

        @Override
        public int get$length() {
            TransactionManager.getInstance().registerRead(this);
            return this.value.length;
        }

        @Override
        public T get(int i) {
            TransactionManager.getInstance().registerRead(this);
            return (T)this.value[i];
        }

        @Override
        public T set(int i, T value) {
            boolean transactionCreated = TransactionManager.getInstance().registerWrite(this);
            this.value[i] = value;
            T result = this.value[i];
            if (transactionCreated) {
                TransactionManager.getInstance().commitTransaction();
            }
            return result;
        }

        @Override
        public void $copyAppStateFrom(Object._Impl other) {
            super.$copyAppStateFrom(other);
            _Impl src = (_Impl)other;
            this.value = src.value;
        }

        @Override
        public void cloneValues() {
            this.value = (Object[])this.value.clone();
        }

        @Override
        protected _Proxy<T> $makeProxy() {
            return new _Proxy(this);
        }

        @Override
        public void $serialize(ObjectOutput out, List<RefTypeEnum> refTypes, List<Long> intraStoreRefs, List<Pair<String, Long>> interStoreRefs) throws IOException {
            super.$serialize(out, refTypes, intraStoreRefs, interStoreRefs);
            out.writeUTF(this.proxyType.getName());
            out.writeInt(this.value.length);
            for (int i = 0; i < this.value.length; ++i) {
                _Impl.$writeRef(this.$getStore(), this.value[i], refTypes, out, intraStoreRefs, interStoreRefs);
            }
        }
    }
}

