/*
 * Decompiled with CFR 0.152.
 */
package fabric.dissemination.pastry.messages;

import fabric.common.exceptions.BadSignatureException;
import fabric.common.util.LongKeyMap;
import fabric.common.util.OidKeyHashMap;
import fabric.common.util.Pair;
import fabric.dissemination.Glob;
import fabric.dissemination.pastry.messages.DataInputBuffer;
import fabric.dissemination.pastry.messages.DataOutputBuffer;
import fabric.worker.RemoteStore;
import fabric.worker.Store;
import fabric.worker.Worker;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import rice.p2p.commonapi.NodeHandle;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.p2p.commonapi.rawserialization.RawMessage;

public class Replicate
implements RawMessage {
    private final transient NodeHandle sender;
    private final int level;
    private final OidKeyHashMap<Long> skip;

    public Replicate(NodeHandle sender, int level, OidKeyHashMap<Long> skip) {
        this.sender = sender;
        this.level = level;
        this.skip = skip;
    }

    public NodeHandle sender() {
        return this.sender;
    }

    public int level() {
        return this.level;
    }

    public OidKeyHashMap<Long> skip() {
        return this.skip;
    }

    public int getPriority() {
        return 0;
    }

    public short getType() {
        return 11;
    }

    public String toString() {
        String s = "Replicate " + this.level + " [";
        for (Store store : this.skip.storeSet()) {
            for (LongKeyMap.Entry<Long> entry : this.skip.get(store).entrySet()) {
                s = s + "(" + store + ", " + entry.getKey() + ", " + entry.getValue() + ")";
            }
        }
        return s + "]";
    }

    public void serialize(OutputBuffer buf) throws IOException {
        buf.writeInt(this.level);
        Set<Store> storeSet = this.skip.storeSet();
        buf.writeInt(storeSet.size());
        for (Store store : storeSet) {
            LongKeyMap<Long> submap = this.skip.get(store);
            buf.writeUTF(store.name());
            buf.writeInt(submap.size());
            for (LongKeyMap.Entry<Long> entry : submap.entrySet()) {
                buf.writeLong(entry.getKey());
                buf.writeLong(entry.getValue().longValue());
            }
        }
    }

    public Replicate(InputBuffer buf, NodeHandle sender) throws IOException {
        Worker worker = Worker.getWorker();
        this.sender = sender;
        this.level = buf.readInt();
        int numStores = buf.readInt();
        this.skip = new OidKeyHashMap();
        for (int i = 0; i < numStores; ++i) {
            RemoteStore store = worker.getStore(buf.readUTF());
            int numEntries = buf.readInt();
            for (int j = 0; j < numEntries; ++j) {
                this.skip.put(store, buf.readLong(), buf.readLong());
            }
        }
    }

    public static class Reply
    implements RawMessage {
        private final Map<Pair<Store, Long>, Glob> globs;

        public Reply(Map<Pair<Store, Long>, Glob> globs) {
            this.globs = globs;
        }

        public Map<Pair<Store, Long>, Glob> globs() {
            return this.globs;
        }

        public int getPriority() {
            return 0;
        }

        public short getType() {
            return 12;
        }

        public String toString() {
            String s = "Replicate.Reply [";
            for (Pair<Store, Long> p : this.globs.keySet()) {
                s = s + p;
            }
            return s + "]";
        }

        public void serialize(OutputBuffer buf) throws IOException {
            DataOutputBuffer out = new DataOutputBuffer(buf);
            out.writeInt(this.globs.size());
            for (Map.Entry<Pair<Store, Long>, Glob> e : this.globs.entrySet()) {
                out.writeUTF(((Store)e.getKey().first).name());
                out.writeLong((Long)e.getKey().second);
                e.getValue().write(out);
            }
        }

        public Reply(InputBuffer buf) throws IOException {
            DataInputBuffer in = new DataInputBuffer(buf);
            Worker worker = Worker.getWorker();
            int n = in.readInt();
            this.globs = new HashMap<Pair<Store, Long>, Glob>(n);
            for (int i = 0; i < n; ++i) {
                RemoteStore store = worker.getStore(in.readUTF());
                long onum = in.readLong();
                try {
                    Glob g = new Glob(store.getPublicKey(), in);
                    this.globs.put(new Pair<RemoteStore, Long>(store, onum), g);
                    continue;
                }
                catch (BadSignatureException e) {
                    // empty catch block
                }
            }
        }
    }
}

