/*
 * Decompiled with CFR 0.152.
 */
package fabric.dissemination.pastry.messages;

import fabric.common.exceptions.BadSignatureException;
import fabric.dissemination.Glob;
import fabric.dissemination.pastry.messages.DataInputBuffer;
import fabric.dissemination.pastry.messages.DataOutputBuffer;
import fabric.worker.Worker;
import java.io.IOException;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.NodeHandle;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.OutputBuffer;
import rice.p2p.commonapi.rawserialization.RawMessage;

public class Fetch
implements RawMessage {
    private final transient NodeHandle sender;
    private final Id id;
    private final String store;
    private final long onum;
    private boolean refresh;
    private transient Reply reply;

    public Fetch(NodeHandle sender, Id id, String store, long onum) {
        this.sender = sender;
        this.id = id;
        this.store = store;
        this.onum = onum;
    }

    public NodeHandle sender() {
        return this.sender;
    }

    public Id id() {
        return this.id;
    }

    public String store() {
        return this.store;
    }

    public long onum() {
        return this.onum;
    }

    public boolean refresh() {
        return this.refresh;
    }

    public void refresh(boolean refresh) {
        this.refresh = refresh;
    }

    public Reply reply() {
        return this.reply;
    }

    public void reply(Reply reply) {
        this.reply = reply;
    }

    public int getPriority() {
        return 0;
    }

    public String toString() {
        return this.store + "/" + this.onum;
    }

    public short getType() {
        return 1;
    }

    public void serialize(OutputBuffer buf) throws IOException {
        buf.writeShort(this.id.getType());
        this.id.serialize(buf);
        buf.writeUTF(this.store);
        buf.writeLong(this.onum);
        buf.writeBoolean(this.refresh);
    }

    public Fetch(InputBuffer buf, Endpoint endpoint, NodeHandle sender) throws IOException {
        this.sender = sender;
        this.id = endpoint.readId(buf, buf.readShort());
        this.store = buf.readUTF();
        this.onum = buf.readLong();
        this.refresh = buf.readBoolean();
    }

    public static class Reply
    implements RawMessage {
        private final Id id;
        private final String store;
        private final long onum;
        private final Glob glob;

        public Reply(Fetch parent, Glob glob) {
            this.id = parent.id();
            this.store = parent.store();
            this.onum = parent.onum();
            this.glob = glob;
        }

        public Glob glob() {
            return this.glob;
        }

        public Id id() {
            return this.id;
        }

        public String store() {
            return this.store;
        }

        public long onum() {
            return this.onum;
        }

        public int getPriority() {
            return 0;
        }

        public short getType() {
            return 2;
        }

        public void serialize(OutputBuffer buf) throws IOException {
            DataOutputBuffer out = new DataOutputBuffer(buf);
            out.writeShort(this.id.getType());
            this.id.serialize((OutputBuffer)out);
            out.writeUTF(this.store);
            out.writeLong(this.onum);
            this.glob.write(out);
        }

        public Reply(InputBuffer buf, Endpoint endpoint) throws IOException {
            Glob glob;
            DataInputBuffer in = new DataInputBuffer(buf);
            this.id = endpoint.readId((InputBuffer)in, in.readShort());
            this.store = in.readUTF();
            this.onum = in.readLong();
            try {
                glob = new Glob(Worker.getWorker().getStore(this.store).getPublicKey(), in);
            }
            catch (BadSignatureException e) {
                glob = null;
            }
            this.glob = glob;
        }
    }
}

