/*
 * Decompiled with CFR 0.152.
 */
package fabric.dissemination.pastry;

import fabric.common.ObjectGroup;
import fabric.common.exceptions.FetchException;
import fabric.common.exceptions.InternalError;
import fabric.common.util.Cache;
import fabric.dissemination.FetchManager;
import fabric.dissemination.Glob;
import fabric.dissemination.pastry.DisseminationTimeoutException;
import fabric.dissemination.pastry.Node;
import fabric.worker.RemoteStore;
import fabric.worker.Worker;
import java.io.IOException;
import java.util.Properties;

public class PastryFetchManager
implements FetchManager {
    private Node node;

    public PastryFetchManager(Worker worker, Properties dissemConfig) {
        try {
            this.node = new Node(dissemConfig);
            worker.registerDisseminationCache(this.node.disseminator.cache);
        }
        catch (IOException e) {
            throw new InternalError(e);
        }
    }

    @Override
    public ObjectGroup fetch(RemoteStore c, long onum) throws FetchException {
        Glob glob;
        try {
            glob = this.node.disseminator().fetch(c, onum);
        }
        catch (DisseminationTimeoutException e) {
            glob = null;
        }
        if (glob == null) {
            return c.readObjectFromStore(onum);
        }
        return glob.decrypt(c);
    }

    @Override
    public void destroy() {
        this.node.destroy();
        Cache.Collector.shutdown();
    }
}

