/*
 * Decompiled with CFR 0.152.
 */
package fabric.dissemination.pastry;

import fabric.common.util.Pair;
import fabric.dissemination.pastry.Disseminator;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.util.Properties;
import rice.environment.Environment;
import rice.environment.params.Parameters;
import rice.pastry.NodeIdFactory;
import rice.pastry.PastryNode;
import rice.pastry.socket.SocketPastryNodeFactory;
import rice.pastry.standard.RandomNodeIdFactory;

public class Node {
    private static int DEFAULT_PORT = 13373;
    protected Environment env = new Environment();
    protected SocketPastryNodeFactory pnf;
    protected PastryNode node;
    protected Disseminator disseminator;

    public Node(Properties dissemConfig) throws IOException {
        String bootHost;
        Parameters params = this.env.getParameters();
        for (Pair property : new Pair[]{new Pair<String, String>("bootstrap", "localhost:13373"), new Pair<String, String>("firewall_test_policy", "never"), new Pair<String, String>("nat_search_policy", "never"), new Pair<String, String>("pastry_socket_allow_loopback", "true"), new Pair<String, String>("replication_interval", "300000"), new Pair<String, String>("aggregation_interval", "600000")}) {
            String key = (String)property.first;
            String value = dissemConfig.getProperty("fabric.dissemination.pastry." + key);
            if (value == null) {
                value = (String)property.second;
            }
            params.setString(key, value);
        }
        String bootstrap = params.getString("bootstrap");
        String[] parts = bootstrap.split(":");
        String string = bootHost = parts.length > 0 ? parts[0] : null;
        if (bootHost.equals("localhost")) {
            bootHost = InetAddress.getLocalHost().getHostName();
        }
        int bootPort = parts.length == 2 ? Integer.parseInt(parts[1]) : DEFAULT_PORT;
        InetSocketAddress boot = new InetSocketAddress(bootHost, bootPort);
        int port = this.findFreePort(DEFAULT_PORT);
        RandomNodeIdFactory idf = new RandomNodeIdFactory(this.env);
        this.pnf = new SocketPastryNodeFactory((NodeIdFactory)idf, port, this.env);
        this.node = this.pnf.newNode(this.pnf.getNodeHandle(boot));
        this.waitForReady();
        this.disseminator = new Disseminator(this.node);
    }

    public Disseminator disseminator() {
        return this.disseminator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForReady() throws IOException {
        int spinCount = 0;
        PastryNode pastryNode = this.node;
        synchronized (pastryNode) {
            while (!this.node.isReady() && !this.node.joinFailed()) {
                try {
                    this.node.wait(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (++spinCount == 2) {
                    System.out.println("Waiting for Pastry node to be ready. (Why does this take so long?)");
                }
                if (spinCount % 20 != 0) continue;
                System.out.println("Still waiting...");
            }
            if (this.node.joinFailed()) {
                throw new IOException("Network error: Could not join Pastry network. (" + this.node.joinFailedReason() + ")");
            }
        }
        if (spinCount >= 2) {
            System.out.println("Pastry node ready.");
        }
    }

    private int findFreePort(int port) {
        while (true) {
            try {
                ServerSocket sock = new ServerSocket();
                sock.bind(new InetSocketAddress(InetAddress.getLocalHost(), port));
                sock.close();
            }
            catch (IOException e) {
                ++port;
                continue;
            }
            break;
        }
        return port;
    }

    public void destroy() {
        this.env.destroy();
    }
}

