/*
 * Decompiled with CFR 0.152.
 */
package fabric.dissemination.pastry;

import fabric.common.Logging;
import fabric.common.util.OidKeyHashMap;
import fabric.common.util.Pair;
import fabric.dissemination.Glob;
import fabric.dissemination.pastry.Cache;
import fabric.dissemination.pastry.DisseminationTimeoutException;
import fabric.dissemination.pastry.messages.AggregateInterval;
import fabric.dissemination.pastry.messages.Fetch;
import fabric.dissemination.pastry.messages.Replicate;
import fabric.dissemination.pastry.messages.ReplicateInterval;
import fabric.worker.RemoteStore;
import fabric.worker.Store;
import fabric.worker.Worker;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import rice.Continuation;
import rice.Executable;
import rice.environment.Environment;
import rice.environment.params.Parameters;
import rice.p2p.commonapi.Application;
import rice.p2p.commonapi.Endpoint;
import rice.p2p.commonapi.Id;
import rice.p2p.commonapi.IdFactory;
import rice.p2p.commonapi.Message;
import rice.p2p.commonapi.NodeHandle;
import rice.p2p.commonapi.RouteMessage;
import rice.p2p.commonapi.rawserialization.InputBuffer;
import rice.p2p.commonapi.rawserialization.MessageDeserializer;
import rice.pastry.PastryNode;
import rice.pastry.commonapi.PastryIdFactory;
import rice.pastry.leafset.LeafSet;
import rice.pastry.routing.RouteSet;
import rice.pastry.routing.RoutingTable;

public class Disseminator
implements Application {
    protected PastryNode node;
    protected Endpoint endpoint;
    protected IdFactory idf;
    protected int idDigits;
    protected int baseBits;
    protected Random rand;
    protected Cache cache;
    protected Map<Id, Fetch> outstanding;
    protected MessageDeserializer deserializer;
    protected long REPLICATION_INTERVAL = 600000L;
    protected long AGGREGATION_INTERVAL = 1200000L;
    private static final Continuation<Object, Exception> halt = new Continuation<Object, Exception>(){

        public void receiveException(Exception result) {
        }

        public void receiveResult(Object result) {
        }
    };

    public Disseminator(PastryNode node) {
        this.node = node;
        this.endpoint = node.buildEndpoint((Application)this, null);
        this.deserializer = new Deserializer();
        this.endpoint.setDeserializer(this.deserializer);
        this.idf = new PastryIdFactory(node.getEnvironment());
        this.rand = new Random();
        RoutingTable rt = node.getRoutingTable();
        this.baseBits = rt.baseBitLength();
        this.idDigits = rt.numRows();
        this.cache = new Cache();
        this.outstanding = new HashMap<Id, Fetch>();
        Environment env = node.getEnvironment();
        Parameters params = env.getParameters();
        try {
            this.REPLICATION_INTERVAL = params.getLong("replication_interval");
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        try {
            this.AGGREGATION_INTERVAL = params.getLong("aggregation_interval");
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        this.endpoint.scheduleMessage((Message)new ReplicateInterval(), this.REPLICATION_INTERVAL, this.REPLICATION_INTERVAL);
        this.endpoint.scheduleMessage((Message)new AggregateInterval(), this.AGGREGATION_INTERVAL, this.AGGREGATION_INTERVAL);
        this.endpoint.register();
        Logging.MISC_LOGGER.info("Pastry disseminator created");
    }

    private void process(Executable<Void, RuntimeException> task) {
        this.endpoint.process(task, halt);
    }

    protected void route(Id id, Message message, NodeHandle hint) {
        this.endpoint.route(id, message, hint);
    }

    protected NodeHandle localHandle() {
        return this.endpoint.getLocalNodeHandle();
    }

    public void deliver(Id id, Message msg) {
        if (msg instanceof Fetch) {
            this.fetch((Fetch)msg);
        } else if (msg instanceof Fetch.Reply) {
            this.fetch((Fetch.Reply)msg);
        } else if (msg instanceof ReplicateInterval) {
            this.replicateInterval();
        } else if (msg instanceof Replicate) {
            this.replicate((Replicate)msg);
        } else if (msg instanceof Replicate.Reply) {
            this.replicate((Replicate.Reply)msg);
        } else if (msg instanceof AggregateInterval) {
            this.aggregateInterval();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Glob fetch(RemoteStore c, long onum) throws DisseminationTimeoutException {
        Glob g = this.cache.get(c, onum);
        if (g != null) {
            return g;
        }
        Id id = this.idf.buildRandomId(this.rand);
        Fetch f = new Fetch(this.localHandle(), id, c.name(), onum);
        Object object = this.outstanding;
        synchronized (object) {
            this.outstanding.put(id, f);
        }
        this.route(this.idf.buildId(f.toString()), (Message)f, null);
        object = f;
        synchronized (object) {
            if (f.reply() == null) {
                try {
                    f.wait(1000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            if (f.reply() == null) {
                throw new DisseminationTimeoutException();
            }
            return f.reply().glob();
        }
    }

    protected void fetch(final Fetch.Reply msg) {
        this.forward(msg);
        this.process(new Executable<Void, RuntimeException>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Void execute() {
                Fetch f = null;
                Object object = Disseminator.this.outstanding;
                synchronized (object) {
                    f = Disseminator.this.outstanding.remove(msg.id());
                }
                if (f != null) {
                    object = f;
                    synchronized (object) {
                        f.reply(msg);
                        f.notifyAll();
                    }
                }
                return null;
            }
        });
    }

    protected void fetch(final Fetch msg) {
        this.process(new Executable<Void, RuntimeException>(){

            public Void execute() {
                long onum;
                Worker worker = Worker.getWorker();
                RemoteStore c = worker.getStore(msg.store());
                Glob g = Disseminator.this.cache.get(c, onum = msg.onum());
                if (g == null) {
                    g = Disseminator.this.cache.get(c, onum, true);
                }
                Disseminator.this.reply(g, msg);
                return null;
            }
        });
    }

    protected void reply(Glob g, Fetch msg) {
        g.touch();
        Fetch.Reply r = new Fetch.Reply(msg, g);
        this.route(null, (Message)r, msg.sender());
    }

    protected void replicateInterval() {
        this.process(new Executable<Void, RuntimeException>(){

            public Void execute() {
                rice.pastry.NodeHandle n2;
                OidKeyHashMap skip;
                rice.pastry.Id me = (rice.pastry.Id)Disseminator.this.localHandle().getId();
                LeafSet ls = Disseminator.this.node.getLeafSet();
                rice.pastry.NodeHandle n1 = ls.get(-1);
                if (n1 != null) {
                    skip = Disseminator.this.skipSet((rice.pastry.Id)n1.getId(), -1);
                    Replicate msg = new Replicate(Disseminator.this.localHandle(), -1, skip);
                    Disseminator.this.route(null, (Message)msg, (NodeHandle)n1);
                }
                if ((n2 = ls.get(1)) != null && !n2.equals(n1)) {
                    skip = Disseminator.this.skipSet((rice.pastry.Id)n2.getId(), -1);
                    Replicate msg = new Replicate(Disseminator.this.localHandle(), -1, skip);
                    Disseminator.this.route(null, (Message)msg, (NodeHandle)n2);
                }
                RoutingTable rt = Disseminator.this.node.getRoutingTable();
                int numDigits = rt.numRows();
                for (int i = 0; i < numDigits; ++i) {
                    int d = me.getDigit(i, (int)rt.baseBitLength());
                    for (int j = 0; j < rt.numColumns(); ++j) {
                        if (j == d) continue;
                        RouteSet rs = rt.getRouteSet(i, j);
                        int level = numDigits - i - 1;
                        if (rs == null || rs.size() <= 0) continue;
                        rice.pastry.NodeHandle n = rs.closestNode();
                        skip = Disseminator.this.skipSet((rice.pastry.Id)n.getId(), level);
                        Replicate msg = new Replicate(Disseminator.this.localHandle(), level, skip);
                        Disseminator.this.route(null, (Message)msg, (NodeHandle)n);
                    }
                }
                return null;
            }
        });
    }

    private OidKeyHashMap<Long> skipSet(rice.pastry.Id deciderId, int level) {
        rice.pastry.Id me = (rice.pastry.Id)this.localHandle().getId();
        OidKeyHashMap<Long> skip = new OidKeyHashMap<Long>();
        for (Pair<Pair<Store, Long>, Long> k : this.cache.timestamps()) {
            rice.pastry.Id id = (rice.pastry.Id)this.idf.buildId(k.first + "/" + k.second);
            boolean send = this.shouldReplicate(deciderId, me, id, level);
            if (!send) continue;
            skip.put((Store)((Pair)k.first).first, (Long)((Pair)k.first).second, (Long)k.second);
        }
        return skip;
    }

    protected void replicate(final Replicate msg) {
        this.process(new Executable<Void, RuntimeException>(){

            public Void execute() {
                NodeHandle sender = msg.sender();
                rice.pastry.Id senderId = (rice.pastry.Id)sender.getId();
                int level = msg.level();
                OidKeyHashMap<Long> skip = msg.skip();
                rice.pastry.Id me = (rice.pastry.Id)Disseminator.this.localHandle().getId();
                HashMap<Pair<Store, Long>, Glob> globs = new HashMap<Pair<Store, Long>, Glob>();
                for (Pair<Pair<Store, Long>, Long> k : Disseminator.this.cache.sortedTimestamps()) {
                    Long onum;
                    RemoteStore c;
                    Glob g;
                    rice.pastry.Id id;
                    boolean send;
                    Long skipTimestamp = skip.get((Store)((Pair)k.first).first, (Long)((Pair)k.first).second);
                    if (skipTimestamp != null && skipTimestamp >= (Long)k.second || !(send = Disseminator.this.shouldReplicate(me, senderId, id = (rice.pastry.Id)Disseminator.this.idf.buildId(k.first + "/" + k.second), level)) || (g = Disseminator.this.cache.get(c = (RemoteStore)((Pair)k.first).first, onum = (Long)((Pair)k.first).second)).level() > level) continue;
                    globs.put((Pair<Store, Long>)k.first, g);
                    if (globs.size() != 10) continue;
                    break;
                }
                if (globs.size() > 0) {
                    Replicate.Reply r = new Replicate.Reply(globs);
                    Disseminator.this.route(null, (Message)r, sender);
                }
                return null;
            }
        });
    }

    private boolean shouldReplicate(rice.pastry.Id deciderId, rice.pastry.Id receiverId, rice.pastry.Id oid, int level) {
        if (level != -1) {
            return oid.indexOfMSDD(deciderId, this.baseBits) < this.idDigits - level;
        }
        return oid.indexOfMSDD(receiverId, this.baseBits) < oid.indexOfMSDD(deciderId, this.baseBits);
    }

    protected void replicate(final Replicate.Reply msg) {
        this.process(new Executable<Void, RuntimeException>(){

            public Void execute() {
                for (Map.Entry<Pair<Store, Long>, Glob> e : msg.globs().entrySet()) {
                    RemoteStore c = (RemoteStore)e.getKey().first;
                    long onum = (Long)e.getKey().second;
                    Glob g = e.getValue();
                    Disseminator.this.cache.put(c, onum, g);
                }
                return null;
            }
        });
    }

    protected void aggregateInterval() {
    }

    public boolean forward(RouteMessage message) {
        try {
            Message m = message.getMessage(this.deserializer);
            if (m instanceof Fetch) {
                return this.forward((Fetch)m);
            }
            if (m instanceof Fetch.Reply) {
                return this.forward((Fetch.Reply)m);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    protected boolean forward(Fetch msg) {
        long onum;
        Worker worker;
        RemoteStore c;
        Glob g;
        if (!msg.refresh() && (g = this.cache.get(c = (worker = Worker.getWorker()).getStore(msg.store()), onum = msg.onum())) != null) {
            this.reply(g, msg);
            return false;
        }
        return true;
    }

    protected boolean forward(Fetch.Reply msg) {
        Worker worker = Worker.getWorker();
        RemoteStore c = worker.getStore(msg.store());
        long onum = msg.onum();
        Glob g = msg.glob();
        if (g != null) {
            this.cache.put(c, onum, g);
        }
        return true;
    }

    public void update(NodeHandle handle, boolean joined) {
    }

    private class Deserializer
    implements MessageDeserializer {
        private Deserializer() {
        }

        public Message deserialize(InputBuffer buf, short type, int priority, NodeHandle sender) throws IOException {
            switch (type) {
                case 1: {
                    return new Fetch(buf, Disseminator.this.endpoint, sender);
                }
                case 2: {
                    return new Fetch.Reply(buf, Disseminator.this.endpoint);
                }
                case 11: {
                    return new Replicate(buf, sender);
                }
                case 12: {
                    return new Replicate.Reply(buf);
                }
            }
            return null;
        }
    }
}

