/*
 * Decompiled with CFR 0.152.
 */
package fabric.dissemination.pastry;

import fabric.common.exceptions.FetchException;
import fabric.common.util.Pair;
import fabric.dissemination.Glob;
import fabric.worker.RemoteStore;
import fabric.worker.Store;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Cache {
    private fabric.common.util.Cache<Pair<Store, Long>, Glob> map = new fabric.common.util.Cache();
    private final Comparator<Pair<Pair<Store, Long>, Long>> TIMESTAMP_COMPARATOR = new Comparator<Pair<Pair<Store, Long>, Long>>(){

        @Override
        public int compare(Pair<Pair<Store, Long>, Long> o1, Pair<Pair<Store, Long>, Long> o2) {
            Glob g2;
            Glob g1 = (Glob)Cache.this.map.get(o1.first);
            if (g1 == (g2 = (Glob)Cache.this.map.get(o2.first))) {
                return 0;
            }
            if (g1 == null) {
                return 1;
            }
            if (g2 == null) {
                return -1;
            }
            return g2.frequency() - g1.frequency();
        }
    };

    public Glob get(RemoteStore store, long onum) {
        return this.get(store, onum, false);
    }

    public Glob get(RemoteStore store, long onum, boolean fetch) {
        Pair<RemoteStore, Long> key = new Pair<RemoteStore, Long>(store, onum);
        Glob g = null;
        g = fetch ? this.fetch(store, onum) : this.map.get(key);
        return g;
    }

    private Glob fetch(RemoteStore c, long onum) {
        Glob g = null;
        try {
            g = c.readEncryptedObjectFromStore(onum);
        }
        catch (FetchException e) {
            // empty catch block
        }
        if (g != null) {
            Pair<RemoteStore, Long> key = new Pair<RemoteStore, Long>(c, onum);
            this.map.put(key, g);
        }
        return g;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(RemoteStore store, long onum, Glob g) {
        Pair<RemoteStore, Long> key = new Pair<RemoteStore, Long>(store, onum);
        fabric.common.util.Cache<Pair<Store, Long>, Glob> cache = this.map;
        synchronized (cache) {
            Glob old = this.get(store, onum);
            if (old == null || old.isOlderThan(g)) {
                this.map.put(key, g);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateEntry(RemoteStore store, long onum, Glob g) {
        Pair<RemoteStore, Long> key = new Pair<RemoteStore, Long>(store, onum);
        fabric.common.util.Cache<Pair<Store, Long>, Glob> cache = this.map;
        synchronized (cache) {
            Glob old = this.get(store, onum);
            if (old == null) {
                return false;
            }
            if (old.isOlderThan(g)) {
                this.map.put(key, g);
            }
        }
        return true;
    }

    public Set<Pair<Pair<Store, Long>, Long>> timestamps() {
        HashSet<Pair<Pair<Store, Long>, Long>> result = new HashSet<Pair<Pair<Store, Long>, Long>>();
        for (Pair<Store, Long> key : this.map.keys()) {
            Glob glob = this.map.get(key);
            if (glob == null) continue;
            result.add(new Pair<Pair<Store, Long>, Long>(key, glob.getTimestamp()));
        }
        return result;
    }

    public List<Pair<Pair<Store, Long>, Long>> sortedTimestamps() {
        ArrayList<Pair<Pair<Store, Long>, Long>> k = new ArrayList<Pair<Pair<Store, Long>, Long>>(this.timestamps());
        Collections.sort(k, this.TIMESTAMP_COMPARATOR);
        return k;
    }
}

