/*
 * Decompiled with CFR 0.152.
 */
package fabric.dissemination;

import fabric.common.Crypto;
import fabric.common.FastSerializable;
import fabric.common.ObjectGroup;
import fabric.common.SerializedObject;
import fabric.common.exceptions.BadSignatureException;
import fabric.common.exceptions.InternalError;
import fabric.lang.security.Label;
import fabric.lang.security.SecretKeyObject;
import fabric.worker.RemoteStore;
import fabric.worker.Store;
import fabric.worker.Worker;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.SecretKey;

public class Glob
implements FastSerializable {
    private final long timestamp;
    private final SecretKeyObject keyObject;
    private final byte[] iv;
    private final byte[] data;
    private final byte[] signature;
    private transient int level;
    private transient int frequency;
    private transient int popularity;
    private transient boolean home;

    public Glob(Store store, ObjectGroup group, PrivateKey key) {
        this.timestamp = System.currentTimeMillis();
        this.keyObject = this.getLabel(store, group).keyObject();
        this.iv = (byte[])(this.keyObject == null ? null : Crypto.makeIV());
        try {
            Cipher cipher = this.makeCipher(this.keyObject, 1, this.iv);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            CipherOutputStream cos = new CipherOutputStream(bos, cipher);
            DataOutputStream out = new DataOutputStream(cos);
            group.write(out);
            out.flush();
            cos.close();
            this.data = bos.toByteArray();
            Signature signer = Crypto.signatureInstance();
            signer.initSign(key);
            this.updateSignature(signer);
            this.signature = signer.sign();
        }
        catch (IOException e) {
            throw new InternalError(e);
        }
        catch (GeneralSecurityException e) {
            throw new InternalError(e);
        }
    }

    private void updateSignature(Signature sig) throws SignatureException {
        sig.update((byte)(this.timestamp >>> 56));
        sig.update((byte)(this.timestamp >>> 48));
        sig.update((byte)(this.timestamp >>> 40));
        sig.update((byte)(this.timestamp >>> 32));
        sig.update((byte)(this.timestamp >>> 24));
        sig.update((byte)(this.timestamp >>> 16));
        sig.update((byte)(this.timestamp >>> 8));
        sig.update((byte)this.timestamp);
        if (this.keyObject != null) {
            try {
                sig.update(this.keyObject.$getStore().name().getBytes("UTF8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new InternalError(e);
            }
            long val = this.keyObject.$getOnum();
            sig.update((byte)(val >>> 56));
            sig.update((byte)(val >>> 48));
            sig.update((byte)(val >>> 40));
            sig.update((byte)(val >>> 32));
            sig.update((byte)(val >>> 24));
            sig.update((byte)(val >>> 16));
            sig.update((byte)(val >>> 8));
            sig.update((byte)val);
        }
        if (this.iv != null) {
            sig.update(this.iv);
        }
        sig.update(this.data);
    }

    private Cipher makeCipher(final SecretKeyObject keyObject, int opmode, byte[] iv) throws GeneralSecurityException {
        byte[] key = null;
        if (keyObject != null) {
            key = Worker.runInSubTransaction(new Worker.Code<SecretKey>(){

                @Override
                public SecretKey run() {
                    return keyObject.getKey();
                }
            }).getEncoded();
        }
        return Crypto.cipherInstance(opmode, key, iv);
    }

    private Label getLabel(Store store, ObjectGroup group) {
        SerializedObject obj = group.objects().entrySet().iterator().next().getValue();
        return new Label._Proxy(store, obj.getLabelOnum());
    }

    public int level() {
        return this.level;
    }

    public void level(int level) {
        this.level = level;
    }

    public int frequency() {
        return this.frequency;
    }

    public void frequency(int frequency) {
        this.frequency = frequency;
    }

    public void touch() {
        ++this.frequency;
    }

    public int popularity() {
        return this.popularity;
    }

    public void popularity(int popularity) {
        this.popularity = popularity;
    }

    public boolean home() {
        return this.home;
    }

    public boolean isOlderThan(Glob glob) {
        return this.timestamp < glob.timestamp;
    }

    public boolean verifySignature(PublicKey key) throws SignatureException, InvalidKeyException {
        Signature verifier = Crypto.signatureInstance();
        verifier.initVerify(key);
        this.updateSignature(verifier);
        return verifier.verify(this.signature);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeLong(this.timestamp);
        if (this.keyObject == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeUTF(this.keyObject.$getStore().name());
            out.writeLong(this.keyObject.$getOnum());
        }
        if (this.iv == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.iv.length);
            out.write(this.iv);
        }
        out.writeInt(this.data.length);
        out.write(this.data);
        out.writeInt(this.signature.length);
        out.write(this.signature);
    }

    public Glob(PublicKey key, DataInput in) throws IOException, BadSignatureException {
        this.timestamp = in.readLong();
        if (in.readBoolean()) {
            RemoteStore store = Worker.getWorker().getStore(in.readUTF());
            this.keyObject = new SecretKeyObject._Proxy((Store)store, in.readLong());
        } else {
            this.keyObject = null;
        }
        int ivLength = in.readInt();
        if (ivLength > 0) {
            this.iv = new byte[ivLength];
            in.readFully(this.iv);
        } else {
            this.iv = null;
        }
        this.data = new byte[in.readInt()];
        in.readFully(this.data);
        this.signature = new byte[in.readInt()];
        in.readFully(this.signature);
        try {
            if (key != null && !this.verifySignature(key)) {
                throw new BadSignatureException();
            }
        }
        catch (GeneralSecurityException e) {
            throw new InternalError(e);
        }
    }

    public ObjectGroup decrypt(Store store) {
        try {
            Cipher cipher = this.makeCipher(this.keyObject, 2, this.iv);
            ByteArrayInputStream bis = new ByteArrayInputStream(this.data);
            DataInputStream in = new DataInputStream(new CipherInputStream(bis, cipher));
            return new ObjectGroup(in);
        }
        catch (IOException e) {
            throw new InternalError(e);
        }
        catch (GeneralSecurityException e) {
            throw new InternalError(e);
        }
    }

    public long getTimestamp() {
        return this.timestamp;
    }
}

