/*
 * Decompiled with CFR 0.152.
 */
package fabric.common.util;

import java.lang.ref.WeakReference;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class WeakReferenceArrayList<T>
implements Iterable<T> {
    private WeakReference<T>[] data = new WeakReference[10];
    private int size = 0;
    private int modCount = 0;

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void clear() {
        if (this.size > 0) {
            ++this.modCount;
            for (int i = 0; i < this.size; ++i) {
                this.data[i] = null;
            }
            this.size = 0;
        }
    }

    public boolean add(T e) {
        if (e == null) {
            throw new IllegalArgumentException();
        }
        ++this.modCount;
        if (this.size == this.data.length) {
            this.ensureCapacity(this.size + 1);
        }
        this.data[this.size++] = new WeakReference<T>(e);
        return true;
    }

    private void compactData() {
        int compactedSize = 0;
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i].get() == null) continue;
            this.data[compactedSize++] = this.data[i];
        }
        this.size = compactedSize;
    }

    private void ensureCapacity(int minCapacity) {
        this.compactData();
        int current = this.data.length;
        if (minCapacity > current) {
            int newCap = current * 2;
            if (minCapacity > newCap) {
                newCap = minCapacity;
            }
            WeakReference[] newData = new WeakReference[newCap];
            for (int i = 0; i < this.size; ++i) {
                newData[i] = this.data[i];
            }
            this.data = newData;
        }
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private int knownMod;
            private int position;
            private int size;
            private T nextElement;
            {
                this.knownMod = WeakReferenceArrayList.this.modCount;
                this.position = 0;
                this.size = WeakReferenceArrayList.this.size;
                this.nextElement = null;
            }

            private void checkMod() {
                if (this.knownMod != WeakReferenceArrayList.this.modCount) {
                    throw new ConcurrentModificationException();
                }
            }

            @Override
            public boolean hasNext() {
                while (this.nextElement == null && this.position < this.size) {
                    this.checkMod();
                    this.nextElement = WeakReferenceArrayList.this.data[this.position++].get();
                }
                return this.nextElement != null;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object result = this.nextElement;
                this.nextElement = null;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

