/*
 * Decompiled with CFR 0.152.
 */
package fabric.common.util;

import fabric.common.util.LongKeyHashMap;
import fabric.common.util.LongKeyMap;
import fabric.lang.Object;
import fabric.worker.Store;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class OidKeyHashMap<V>
implements Iterable<LongKeyMap<V>> {
    Map<Store, LongKeyMap<V>> map = new HashMap<Store, LongKeyMap<V>>();
    boolean hasNullEntry = false;
    V nullEntry = null;

    public OidKeyHashMap() {
    }

    public OidKeyHashMap(OidKeyHashMap<V> other) {
        this();
        for (Map.Entry<Store, LongKeyMap<V>> entry : other.map.entrySet()) {
            this.map.put(entry.getKey(), new LongKeyHashMap<V>(entry.getValue()));
        }
        this.hasNullEntry = other.hasNullEntry;
        this.nullEntry = other.nullEntry;
    }

    public LongKeyMap<V> get(Store store) {
        return this.map.get(store);
    }

    public void clear() {
        this.map.clear();
        this.hasNullEntry = false;
        this.nullEntry = null;
    }

    public boolean containsKey(Object obj) {
        return obj == null ? this.hasNullEntry : this.containsKey(obj.$getStore(), obj.$getOnum());
    }

    public boolean containsKey(Store store, long onum) {
        LongKeyMap<V> submap = this.map.get(store);
        return submap != null && submap.containsKey(onum);
    }

    public V get(Object obj) {
        return obj == null ? this.nullEntry : this.get(obj.$getStore(), obj.$getOnum());
    }

    public V get(Store store, long onum) {
        LongKeyMap<V> submap = this.map.get(store);
        return submap == null ? null : (V)submap.get(onum);
    }

    public V put(Object obj, V val) {
        if (obj == null) {
            this.hasNullEntry = true;
            V result = this.nullEntry;
            this.nullEntry = val;
            return result;
        }
        return this.put(obj.$getStore(), obj.$getOnum(), val);
    }

    public V put(Store store, long onum, V val) {
        LongKeyMap<V> submap = this.map.get(store);
        if (submap == null) {
            submap = new LongKeyHashMap();
            this.map.put(store, submap);
        }
        return submap.put(onum, val);
    }

    public V remove(Object obj) {
        if (obj == null) {
            V result = this.nullEntry;
            this.hasNullEntry = false;
            this.nullEntry = null;
            return result;
        }
        return this.remove(obj.$getStore(), obj.$getOnum());
    }

    public V remove(Store store, long onum) {
        LongKeyMap<V> submap = this.map.get(store);
        if (submap == null) {
            return null;
        }
        V result = submap.remove(onum);
        if (submap.isEmpty()) {
            this.map.remove(store);
        }
        return result;
    }

    public Set<Store> storeSet() {
        return this.map.keySet();
    }

    @Override
    public Iterator<LongKeyMap<V>> iterator() {
        return this.map.values().iterator();
    }

    public boolean isEmpty() {
        return !this.hasNullEntry && this.map.isEmpty();
    }

    public int size() {
        int result = 0;
        for (LongKeyMap<V> submap : this) {
            result += submap.size();
        }
        return result;
    }
}

