/*
 * Decompiled with CFR 0.152.
 */
package fabric.common.util;

import fabric.common.util.AbstractLongKeyMap;
import fabric.common.util.AbstractLongSet;
import fabric.common.util.LongIterator;
import fabric.common.util.LongKeyMap;
import fabric.common.util.LongSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class LongKeyHashMap<V>
extends AbstractLongKeyMap<V>
implements LongKeyMap<V>,
Cloneable,
Serializable {
    static final int DEFAULT_CAPACITY = 11;
    static final float DEFAULT_LOAD_FACTOR = 1.0f;
    private int threshold;
    final float loadFactor;
    transient HashEntry<V>[] buckets;
    transient int modCount;
    transient int size;
    private transient Set<LongKeyMap.Entry<V>> entries;

    public LongKeyHashMap() {
        this(11, 1.0f);
    }

    public LongKeyHashMap(LongKeyMap<? extends V> m) {
        this(Math.max(m.size() * 2, 11), 1.0f);
        this.putAll(m);
    }

    public LongKeyHashMap(int initialCapacity) {
        this(initialCapacity, 1.0f);
    }

    public LongKeyHashMap(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
        if (!(loadFactor > 0.0f)) {
            throw new IllegalArgumentException("Illegal Load: " + loadFactor);
        }
        if (initialCapacity == 0) {
            initialCapacity = 1;
        }
        this.buckets = new HashEntry[initialCapacity];
        this.loadFactor = loadFactor;
        this.threshold = (int)((float)initialCapacity * loadFactor);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public V get(long key) {
        int idx = this.hash(key);
        HashEntry<V> e = this.buckets[idx];
        while (e != null) {
            if (key == e.key) {
                return (V)e.value;
            }
            e = e.next;
        }
        return null;
    }

    @Override
    public boolean containsKey(long key) {
        int idx = this.hash(key);
        HashEntry<V> e = this.buckets[idx];
        while (e != null) {
            if (key == e.key) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    @Override
    public V put(long key, V value) {
        int idx = this.hash(key);
        HashEntry<V> e = this.buckets[idx];
        while (e != null) {
            if (key == e.key) {
                e.access();
                Object r = e.value;
                e.value = value;
                return (V)r;
            }
            e = e.next;
        }
        ++this.modCount;
        if (++this.size > this.threshold) {
            this.rehash();
            idx = this.hash(key);
        }
        this.addEntry(key, value, idx, true);
        return null;
    }

    @Override
    public <T extends V> void putAll(LongKeyMap<T> m) {
        for (LongKeyMap.Entry<T> e : m.entrySet()) {
            if (e instanceof AbstractLongKeyMap.SimpleEntry) {
                AbstractLongKeyMap.SimpleEntry entry = (AbstractLongKeyMap.SimpleEntry)e;
                this.put(entry.key, entry.value);
                continue;
            }
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public V remove(long key) {
        int idx = this.hash(key);
        HashEntry<V> e = this.buckets[idx];
        HashEntry<V> last = null;
        while (e != null) {
            if (key == e.key) {
                ++this.modCount;
                if (last == null) {
                    this.buckets[idx] = e.next;
                } else {
                    last.next = e.next;
                }
                --this.size;
                return e.cleanup();
            }
            last = e;
            e = e.next;
        }
        return null;
    }

    @Override
    public void clear() {
        if (this.size != 0) {
            ++this.modCount;
            Arrays.fill(this.buckets, null);
            this.size = 0;
        }
    }

    @Override
    public boolean containsValue(Object value) {
        for (int i = this.buckets.length - 1; i >= 0; --i) {
            HashEntry<V> e = this.buckets[i];
            while (e != null) {
                if (LongKeyHashMap.equals(value, e.value)) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    @Override
    public Object clone() {
        LongKeyHashMap copy = null;
        try {
            copy = (LongKeyHashMap)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        copy.buckets = new HashEntry[this.buckets.length];
        copy.putAllInternal(this);
        copy.entries = null;
        return copy;
    }

    @Override
    public LongSet keySet() {
        if (this.keys == null) {
            this.keys = new AbstractLongSet(){

                @Override
                public int size() {
                    return LongKeyHashMap.this.size;
                }

                @Override
                public LongIterator iterator() {
                    return LongKeyHashMap.this.keyIterator();
                }

                @Override
                public void clear() {
                    LongKeyHashMap.this.clear();
                }

                @Override
                public boolean contains(long o) {
                    return LongKeyHashMap.this.containsKey(o);
                }

                @Override
                public boolean remove(long o) {
                    int oldsize = LongKeyHashMap.this.size;
                    LongKeyHashMap.this.remove(o);
                    return oldsize != LongKeyHashMap.this.size;
                }
            };
        }
        return this.keys;
    }

    @Override
    public Collection<V> values() {
        if (this.values == null) {
            this.values = new AbstractCollection<V>(){

                @Override
                public int size() {
                    return LongKeyHashMap.this.size;
                }

                @Override
                public Iterator<V> iterator() {
                    return LongKeyHashMap.this.iterator(1);
                }

                @Override
                public void clear() {
                    LongKeyHashMap.this.clear();
                }
            };
        }
        return this.values;
    }

    @Override
    public Set<LongKeyMap.Entry<V>> entrySet() {
        if (this.entries == null) {
            this.entries = new AbstractSet<LongKeyMap.Entry<V>>(){

                @Override
                public int size() {
                    return LongKeyHashMap.this.size;
                }

                @Override
                public Iterator<LongKeyMap.Entry<V>> iterator() {
                    return LongKeyHashMap.this.iterator(2);
                }

                @Override
                public void clear() {
                    LongKeyHashMap.this.clear();
                }

                @Override
                public boolean contains(Object o) {
                    return LongKeyHashMap.this.getEntry(o) != null;
                }

                @Override
                public boolean remove(Object o) {
                    HashEntry e = LongKeyHashMap.this.getEntry(o);
                    if (e != null) {
                        LongKeyHashMap.this.remove(e.key);
                        return true;
                    }
                    return false;
                }
            };
        }
        return this.entries;
    }

    void addEntry(long key, V value, int idx, boolean callRemove) {
        HashEntry<V> e = new HashEntry<V>(key, value);
        e.next = this.buckets[idx];
        this.buckets[idx] = e;
    }

    final HashEntry<V> getEntry(Object o) {
        if (!(o instanceof Map.Entry)) {
            return null;
        }
        LongKeyMap.Entry me = (LongKeyMap.Entry)o;
        long key = me.getKey();
        int idx = this.hash(key);
        HashEntry<V> e = this.buckets[idx];
        while (e != null) {
            if (e.key == key) {
                return LongKeyHashMap.equals(e.value, me.getValue()) ? e : null;
            }
            e = e.next;
        }
        return null;
    }

    final int hash(long key) {
        return Math.abs(LongKeyHashMap.hashCode(key) % this.buckets.length);
    }

    <T> Iterator<T> iterator(int type) {
        return new HashIterator(type);
    }

    LongIterator keyIterator() {
        return new KeyIterator();
    }

    void putAllInternal(LongKeyMap<? extends V> m) {
        LongKeyMap<V> addMap = m;
        Iterator<LongKeyMap.Entry<V>> it = addMap.entrySet().iterator();
        this.size = 0;
        while (it.hasNext()) {
            LongKeyMap.Entry<V> e = it.next();
            ++this.size;
            long key = e.getKey();
            int idx = this.hash(key);
            this.addEntry(key, e.getValue(), idx, false);
        }
    }

    private void rehash() {
        HashEntry<V>[] oldBuckets = this.buckets;
        int newcapacity = this.buckets.length * 2 + 1;
        this.threshold = (int)((float)newcapacity * this.loadFactor);
        this.buckets = new HashEntry[newcapacity];
        for (int i = oldBuckets.length - 1; i >= 0; --i) {
            HashEntry<V> e = oldBuckets[i];
            while (e != null) {
                int idx = this.hash(e.key);
                HashEntry next = e.next;
                e.next = this.buckets[idx];
                this.buckets[idx] = e;
                e = next;
            }
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.buckets.length);
        s.writeInt(this.size);
        Iterator it = this.iterator(2);
        while (it.hasNext()) {
            HashEntry entry = (HashEntry)it.next();
            s.writeLong(entry.key);
            s.writeObject(entry.value);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        int len;
        s.defaultReadObject();
        this.buckets = new HashEntry[s.readInt()];
        this.size = len = s.readInt();
        while (len-- > 0) {
            long key = s.readLong();
            this.addEntry(key, s.readObject(), this.hash(key), false);
        }
    }

    private final class KeyIterator
    implements LongIterator {
        private int knownMod;
        private int count;
        private int idx;
        private HashEntry<V> last;
        private HashEntry<V> next;

        KeyIterator() {
            this.knownMod = LongKeyHashMap.this.modCount;
            this.count = LongKeyHashMap.this.size;
            this.idx = LongKeyHashMap.this.buckets.length;
        }

        @Override
        public boolean hasNext() {
            return this.count > 0;
        }

        @Override
        public long next() {
            if (this.knownMod != LongKeyHashMap.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.count == 0) {
                throw new NoSuchElementException();
            }
            --this.count;
            HashEntry e = this.next;
            while (e == null) {
                e = LongKeyHashMap.this.buckets[--this.idx];
            }
            this.next = e.next;
            this.last = e;
            return e.key;
        }

        @Override
        public void remove() {
            if (this.knownMod != LongKeyHashMap.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.last == null) {
                throw new IllegalStateException();
            }
            LongKeyHashMap.this.remove(this.last.key);
            this.last = null;
            ++this.knownMod;
        }
    }

    private final class HashIterator<T>
    implements Iterator<T> {
        private final int type;
        private int knownMod;
        private int count;
        private int idx;
        private HashEntry<V> last;
        private HashEntry<V> next;

        HashIterator(int type) {
            this.knownMod = LongKeyHashMap.this.modCount;
            this.count = LongKeyHashMap.this.size;
            this.idx = LongKeyHashMap.this.buckets.length;
            this.type = type;
        }

        @Override
        public boolean hasNext() {
            return this.count > 0;
        }

        @Override
        public T next() {
            if (this.knownMod != LongKeyHashMap.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.count == 0) {
                throw new NoSuchElementException();
            }
            --this.count;
            HashEntry e = this.next;
            while (e == null) {
                e = LongKeyHashMap.this.buckets[--this.idx];
            }
            this.next = e.next;
            this.last = e;
            if (this.type == 1) {
                return (T)e.value;
            }
            return (T)e;
        }

        @Override
        public void remove() {
            if (this.knownMod != LongKeyHashMap.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.last == null) {
                throw new IllegalStateException();
            }
            LongKeyHashMap.this.remove(this.last.key);
            this.last = null;
            ++this.knownMod;
        }
    }

    static class HashEntry<V>
    extends AbstractLongKeyMap.SimpleEntry<V> {
        HashEntry<V> next;

        HashEntry(long key, V value) {
            super(key, value);
        }

        void access() {
        }

        V cleanup() {
            return (V)this.value;
        }
    }
}

