/*
 * Decompiled with CFR 0.152.
 */
package fabric.common.util;

import fabric.common.util.LongKeyHashMap;
import fabric.common.util.LongKeyMap;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;

public class LongKeyCache<V> {
    private final LongKeyMap<ValueSoftRef<V>> map = new LongKeyHashMap<ValueSoftRef<V>>();
    private static final ReferenceQueue<Object> queue = new ReferenceQueue();
    private static final Collector collector = new Collector();

    public synchronized void clear() {
        this.map.clear();
    }

    public synchronized boolean containsKey(long key) {
        return this.map.containsKey(key);
    }

    public synchronized V get(long key) {
        ValueSoftRef<V> ref = this.map.get(key);
        if (ref == null) {
            return null;
        }
        return (V)ref.get();
    }

    public synchronized V put(long key, V value) {
        ValueSoftRef ref = null;
        if (value != null) {
            ref = new ValueSoftRef(this, key, value);
        }
        if ((ref = (ValueSoftRef)this.map.put(key, ref)) == null) {
            return null;
        }
        return (V)ref.get();
    }

    public synchronized V remove(long key) {
        ValueSoftRef<V> ref = this.map.remove(key);
        if (ref == null) {
            return null;
        }
        return (V)ref.get();
    }

    static {
        collector.start();
    }

    public static final class Collector
    extends Thread {
        private boolean destroyed;

        private Collector() {
            super("Cache entry collector");
        }

        public static void shutdown() {
            collector.destroyed = true;
            collector.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.destroyed) {
                try {
                    ValueSoftRef ref = (ValueSoftRef)queue.remove();
                    LongKeyCache longKeyCache = ref.cache;
                    synchronized (longKeyCache) {
                        ValueSoftRef curRef = (ValueSoftRef)ref.cache.map.get(ref.key);
                        if (ref == curRef) {
                            ref.cache.remove(ref.key);
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }

    private static final class ValueSoftRef<V>
    extends SoftReference<V> {
        final long key;
        final LongKeyCache<V> cache;

        public ValueSoftRef(LongKeyCache<V> cache, long key, V value) {
            super(value);
            this.key = key;
            this.cache = cache;
        }

        public boolean equals(Object obj) {
            Object val = this.get();
            if (val == null) {
                return false;
            }
            return val.equals(obj);
        }
    }
}

