/*
 * Decompiled with CFR 0.152.
 */
package fabric.common.util;

import fabric.common.util.AbstractLongSet;
import fabric.common.util.LongCollection;
import fabric.common.util.LongIterator;
import fabric.common.util.LongKeyHashMap;
import fabric.common.util.LongSet;

public class LongHashSet
extends AbstractLongSet
implements LongSet {
    private transient LongKeyHashMap<String> map;

    public LongHashSet() {
        this(11, 1.0f);
    }

    public LongHashSet(int initialCapacity) {
        this(initialCapacity, 1.0f);
    }

    public LongHashSet(int initialCapacity, float loadFactor) {
        this.map = this.init(initialCapacity, loadFactor);
    }

    public LongHashSet(LongCollection c) {
        this(Math.max(2 * c.size(), 11));
        this.addAll(c);
    }

    @Override
    public boolean add(long v) {
        return this.map.put(v, "") == null;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean contains(long v) {
        return this.map.containsKey(v);
    }

    @Override
    public boolean isEmpty() {
        return this.map.size == 0;
    }

    @Override
    public LongIterator iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public boolean remove(long v) {
        return this.map.remove(v) != null;
    }

    @Override
    public int size() {
        return this.map.size;
    }

    LongKeyHashMap<String> init(int capacity, float load) {
        return new LongKeyHashMap<String>(capacity, load);
    }
}

