/*
 * Decompiled with CFR 0.152.
 */
package fabric.common.util;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Cache<K, V> {
    private final Map<K, ValueSoftRef<K, V>> map = new HashMap<K, ValueSoftRef<K, V>>();
    private static final ReferenceQueue<Object> queue = new ReferenceQueue();
    private static final Collector collector = new Collector();

    public synchronized void clear() {
        this.map.clear();
    }

    public synchronized boolean containsKey(K key) {
        return this.map.containsKey(key);
    }

    public synchronized V get(K key) {
        ValueSoftRef<K, V> ref = this.map.get(key);
        if (ref == null) {
            return null;
        }
        return (V)ref.get();
    }

    public synchronized V put(K key, V value) {
        ValueSoftRef ref = null;
        if (value != null) {
            ref = new ValueSoftRef(this, key, value);
        }
        if ((ref = (ValueSoftRef)this.map.put(key, ref)) == null) {
            return null;
        }
        return (V)ref.get();
    }

    public synchronized V remove(Object key) {
        ValueSoftRef<K, V> ref = this.map.remove(key);
        if (ref == null) {
            return null;
        }
        return (V)ref.get();
    }

    public synchronized Set<K> keys() {
        return new HashSet<K>(this.map.keySet());
    }

    static {
        collector.start();
    }

    public static final class Collector
    extends Thread {
        private boolean destroyed;

        private Collector() {
            super("Cache entry collector");
        }

        public static void shutdown() {
            collector.destroyed = true;
            collector.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.destroyed) {
                try {
                    ValueSoftRef ref = (ValueSoftRef)queue.remove();
                    Cache cache = ref.cache;
                    synchronized (cache) {
                        ValueSoftRef curRef = (ValueSoftRef)ref.cache.map.get(ref.key);
                        if (ref == curRef) {
                            ref.cache.remove(ref.key);
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }

    private static final class ValueSoftRef<K, V>
    extends SoftReference<V> {
        final K key;
        final Cache<K, V> cache;

        public ValueSoftRef(Cache<K, V> cache, K key, V value) {
            super(value);
            this.key = key;
            this.cache = cache;
        }

        public boolean equals(Object obj) {
            Object val = this.get();
            if (val == null) {
                return false;
            }
            return val.equals(obj);
        }
    }
}

