/*
 * Decompiled with CFR 0.152.
 */
package fabric.common.util;

import fabric.common.util.AbstractLongSet;
import fabric.common.util.LongIterator;
import fabric.common.util.LongKeyMap;
import fabric.common.util.LongSet;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public abstract class AbstractLongKeyMap<V>
implements LongKeyMap<V> {
    static final int VALUES = 1;
    static final int ENTRIES = 2;
    LongSet keys;
    Collection<V> values;

    protected AbstractLongKeyMap() {
    }

    @Override
    public abstract Set<LongKeyMap.Entry<V>> entrySet();

    @Override
    public void clear() {
        this.entrySet().clear();
    }

    protected Object clone() throws CloneNotSupportedException {
        AbstractLongKeyMap copy = (AbstractLongKeyMap)super.clone();
        copy.keys = null;
        copy.values = null;
        return copy;
    }

    @Override
    public boolean containsKey(long key) {
        Iterator<LongKeyMap.Entry<V>> entries = this.entrySet().iterator();
        int pos = this.size();
        while (--pos >= 0) {
            if (key != entries.next().getKey()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        Iterator<LongKeyMap.Entry<V>> entries = this.entrySet().iterator();
        int pos = this.size();
        while (--pos >= 0) {
            if (!AbstractLongKeyMap.equals(value, entries.next().getValue())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean equals(Object o) {
        return o == this || o instanceof LongKeyMap && ((Object)this.entrySet()).equals(((LongKeyMap)o).entrySet());
    }

    @Override
    public V get(long key) {
        Iterator<LongKeyMap.Entry<V>> entries = this.entrySet().iterator();
        int pos = this.size();
        while (--pos >= 0) {
            LongKeyMap.Entry<V> entry = entries.next();
            if (key != entry.getKey()) continue;
            return entry.getValue();
        }
        return null;
    }

    @Override
    public int hashCode() {
        return ((Object)this.entrySet()).hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public LongSet keySet() {
        if (this.keys == null) {
            this.keys = new AbstractLongSet(){

                @Override
                public int size() {
                    return AbstractLongKeyMap.this.size();
                }

                @Override
                public boolean contains(long key) {
                    return AbstractLongKeyMap.this.containsKey(key);
                }

                @Override
                public LongIterator iterator() {
                    return new LongIterator(){
                        private final Iterator<LongKeyMap.Entry<V>> map_iterator;
                        {
                            this.map_iterator = AbstractLongKeyMap.this.entrySet().iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.map_iterator.hasNext();
                        }

                        @Override
                        public long next() {
                            return this.map_iterator.next().getKey();
                        }

                        @Override
                        public void remove() {
                            this.map_iterator.remove();
                        }
                    };
                }
            };
        }
        return this.keys;
    }

    @Override
    public V put(long key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T extends V> void putAll(LongKeyMap<T> m) {
        Iterator<LongKeyMap.Entry<T>> entries = m.entrySet().iterator();
        int pos = m.size();
        while (--pos >= 0) {
            LongKeyMap.Entry<T> entry = entries.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(long key) {
        Iterator<LongKeyMap.Entry<V>> entries = this.entrySet().iterator();
        int pos = this.size();
        while (--pos >= 0) {
            LongKeyMap.Entry<V> entry = entries.next();
            if (key != entry.getKey()) continue;
            V r = entry.getValue();
            entries.remove();
            return r;
        }
        return null;
    }

    @Override
    public int size() {
        return this.entrySet().size();
    }

    public String toString() {
        Iterator<LongKeyMap.Entry<V>> entries = this.entrySet().iterator();
        StringBuilder r = new StringBuilder("{");
        for (int pos = this.size(); pos > 0; --pos) {
            LongKeyMap.Entry<V> entry = entries.next();
            r.append(entry.getKey());
            r.append('=');
            r.append(entry.getValue());
            if (pos <= 1) continue;
            r.append(", ");
        }
        r.append("}");
        return r.toString();
    }

    @Override
    public Collection<V> values() {
        if (this.values == null) {
            this.values = new AbstractCollection<V>(){

                @Override
                public int size() {
                    return AbstractLongKeyMap.this.size();
                }

                @Override
                public boolean contains(Object value) {
                    return AbstractLongKeyMap.this.containsValue(value);
                }

                @Override
                public Iterator<V> iterator() {
                    return new Iterator<V>(){
                        private final Iterator<LongKeyMap.Entry<V>> map_iterator;
                        {
                            this.map_iterator = AbstractLongKeyMap.this.entrySet().iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.map_iterator.hasNext();
                        }

                        @Override
                        public V next() {
                            return this.map_iterator.next().getValue();
                        }

                        @Override
                        public void remove() {
                            this.map_iterator.remove();
                        }
                    };
                }
            };
        }
        return this.values;
    }

    static final boolean equals(Object o1, Object o2) {
        return o1 == o2 || o1 != null && o1.equals(o2);
    }

    static final int hashCode(Object o) {
        return o == null ? 0 : o.hashCode();
    }

    static final int hashCode(long o) {
        return (int)(o ^ o >>> 32);
    }

    public static class SimpleEntry<V>
    implements LongKeyMap.Entry<V>,
    Serializable {
        long key;
        V value;

        public SimpleEntry(long newKey, V newValue) {
            this.key = newKey;
            this.value = newValue;
        }

        public SimpleEntry(LongKeyMap.Entry<? extends V> entry) {
            this(entry.getKey(), entry.getValue());
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof LongKeyMap.Entry)) {
                return false;
            }
            if (o instanceof SimpleEntry) {
                SimpleEntry e = (SimpleEntry)o;
                return this.key == e.key && AbstractLongKeyMap.equals(this.value, e.value);
            }
            LongKeyMap.Entry e = (LongKeyMap.Entry)o;
            return this.key == e.getKey() && AbstractLongKeyMap.equals(this.value, e.getValue());
        }

        @Override
        public long getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public int hashCode() {
            return AbstractLongKeyMap.hashCode(this.key) ^ AbstractLongKeyMap.hashCode(this.value);
        }

        @Override
        public V setValue(V newVal) {
            V r = this.value;
            this.value = newVal;
            return r;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    public static class SimpleImmutableEntry<V>
    implements LongKeyMap.Entry<V>,
    Serializable {
        long key;
        V value;

        public SimpleImmutableEntry(long key, V value) {
            this.key = key;
            this.value = value;
        }

        public SimpleImmutableEntry(LongKeyMap.Entry<? extends V> entry) {
            this(entry.getKey(), entry.getValue());
        }

        @Override
        public long getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException("setValue not supported on immutable entry");
        }
    }
}

