/*
 * Decompiled with CFR 0.152.
 */
package fabric.common.util;

import fabric.common.util.LongCollection;
import fabric.common.util.LongIterable;
import fabric.common.util.LongIterator;

public abstract class AbstractLongCollection
implements LongCollection,
LongIterable {
    protected AbstractLongCollection() {
    }

    @Override
    public abstract LongIterator iterator();

    @Override
    public abstract int size();

    @Override
    public boolean add(long o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(LongCollection c) {
        LongIterator itr = c.iterator();
        boolean modified = false;
        int pos = c.size();
        while (--pos >= 0) {
            modified |= this.add(itr.next());
        }
        return modified;
    }

    @Override
    public void clear() {
        LongIterator itr = this.iterator();
        int pos = this.size();
        while (--pos >= 0) {
            itr.next();
            itr.remove();
        }
    }

    @Override
    public boolean contains(long o) {
        LongIterator itr = this.iterator();
        int pos = this.size();
        while (--pos >= 0) {
            if (o != itr.next()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(LongCollection c) {
        LongIterator itr = c.iterator();
        int pos = c.size();
        while (--pos >= 0) {
            if (this.contains(itr.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean remove(long o) {
        LongIterator itr = this.iterator();
        int pos = this.size();
        while (--pos >= 0) {
            if (o != itr.next()) continue;
            itr.remove();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(LongCollection c) {
        return this.removeAllInternal(c);
    }

    boolean removeAllInternal(LongCollection c) {
        LongIterator itr = this.iterator();
        boolean modified = false;
        int pos = this.size();
        while (--pos >= 0) {
            if (!c.contains(itr.next())) continue;
            itr.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean retainAll(LongCollection c) {
        return this.retainAllInternal(c);
    }

    boolean retainAllInternal(LongCollection c) {
        LongIterator itr = this.iterator();
        boolean modified = false;
        int pos = this.size();
        while (--pos >= 0) {
            if (c.contains(itr.next())) continue;
            itr.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public long[] toArray() {
        LongIterator itr = this.iterator();
        int size = this.size();
        long[] a = new long[size];
        for (int pos = 0; pos < size; ++pos) {
            a[pos] = itr.next();
        }
        return a;
    }

    @Override
    public long[] toArray(long[] a) {
        int size = this.size();
        if (a.length < size) {
            a = new long[size];
        } else if (a.length > size) {
            a[size] = 0L;
        }
        LongIterator itr = this.iterator();
        for (int pos = 0; pos < size; ++pos) {
            a[pos] = itr.next();
        }
        return a;
    }

    public String toString() {
        LongIterator itr = this.iterator();
        StringBuffer r = new StringBuffer("[");
        boolean hasNext = itr.hasNext();
        while (hasNext) {
            long o = itr.next();
            r.append(o);
            hasNext = itr.hasNext();
            if (!hasNext) continue;
            r.append(", ");
        }
        r.append("]");
        return r.toString();
    }

    static final boolean equals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    static final int hashCode(Object o) {
        return o == null ? 0 : o.hashCode();
    }

    static final int hashCode(long o) {
        return (int)(o ^ o >>> 32);
    }
}

