/*
 * Decompiled with CFR 0.152.
 */
package fabric.common.net.naming;

import java.net.InetAddress;
import java.net.InetSocketAddress;

public final class SocketAddress {
    private final InetAddress addr;
    private final int port;

    public SocketAddress(InetAddress addr, int port) {
        this.addr = addr;
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public InetAddress getAddress() {
        return this.addr;
    }

    public InetSocketAddress toInetSocketAddress() {
        return new InetSocketAddress(this.getAddress(), this.getPort());
    }

    public String toString() {
        String result = this.addr == null ? "" : this.addr.toString();
        return result + ":" + this.port;
    }

    public boolean equals(Object o) {
        if (!(o instanceof SocketAddress)) {
            return false;
        }
        SocketAddress other = (SocketAddress)o;
        if (this.port != other.port) {
            return false;
        }
        if (null == this.addr && null == other.addr) {
            return true;
        }
        if (null == this.addr || null == other.addr) {
            return false;
        }
        return this.addr.equals(other.addr);
    }

    public int hashCode() {
        if (null == this.addr) {
            return this.port;
        }
        return this.addr.hashCode() ^ this.port;
    }
}

