/*
 * Decompiled with CFR 0.152.
 */
package fabric.common.net.naming;

import fabric.common.ConfigProperties;
import fabric.common.Logging;
import fabric.common.Resources;
import fabric.common.net.naming.NameService;
import fabric.common.net.naming.SocketAddress;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

public class DefaultNameService
implements NameService {
    private Map<String, SocketAddress> entries;
    private SocketAddress defaultAddr;

    /*
     * WARNING - void declaration
     */
    public DefaultNameService(PortType portType) throws IOException {
        void var6_9;
        ConfigProperties defs = ConfigProperties.getDefaults();
        this.defaultAddr = new SocketAddress(null, portType.getPort(defs));
        this.entries = new HashMap<String, SocketAddress>();
        File directory = Resources.getFile("etc", "config");
        File[] arr$ = directory.listFiles();
        int len$ = arr$.length;
        boolean bl = false;
        while (var6_9 < len$) {
            File f = arr$[var6_9];
            if (f.getName().endsWith(".properties")) {
                String name = f.getName();
                name = name.substring(0, name.lastIndexOf(46));
                ConfigProperties props = new ConfigProperties(name);
                String host = props.hostname;
                int port = portType.getPort(props);
                this.entries.put(name, new SocketAddress(InetAddress.getByName(host), port));
            }
            ++var6_9;
        }
        if (Logging.NAMING_LOGGER.isLoggable(Level.FINEST)) {
            int size = 0;
            for (String string : this.entries.keySet()) {
                size = string.length() > size ? string.length() : size;
            }
            for (Map.Entry entry : this.entries.entrySet()) {
                Logging.NAMING_LOGGER.finest(String.format("name service: %1$" + size + "s -> %2$s", entry.getKey(), entry.getValue()));
            }
        }
    }

    @Override
    public SocketAddress localResolve(String name) {
        SocketAddress result = this.entries.get(name);
        if (result == null) {
            result = this.defaultAddr;
        }
        return result;
    }

    @Override
    public SocketAddress resolve(String name) {
        SocketAddress result = this.entries.get(name);
        if (result == null) {
            result = this.defaultAddr;
        }
        return result;
    }

    public static enum PortType {
        WORKER{

            @Override
            int getPort(ConfigProperties p) {
                return p.workerPort;
            }
        }
        ,
        STORE{

            @Override
            int getPort(ConfigProperties p) {
                return p.storePort;
            }
        };


        abstract int getPort(ConfigProperties var1);
    }
}

