/*
 * Decompiled with CFR 0.152.
 */
package fabric.common.net.handshake;

import fabric.common.net.handshake.HandshakeProtocol;
import fabric.common.net.handshake.ShakenSocket;
import fabric.common.net.naming.SocketAddress;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;

public class HandshakeImpl
implements HandshakeProtocol {
    private ConnType type;

    @Override
    public ShakenSocket initiate(String name, SocketAddress addr) throws IOException {
        Socket s = new Socket(addr.getAddress(), addr.getPort());
        this.fixSocket(s);
        DataOutputStream out = new DataOutputStream(s.getOutputStream());
        out.writeUTF(name);
        out.write(this.type.ordinal());
        out.flush();
        return new ShakenSocket(name, null, s);
    }

    @Override
    public ShakenSocket receive(Socket s) throws IOException {
        this.fixSocket(s);
        DataInputStream in = new DataInputStream(s.getInputStream());
        String name = in.readUTF();
        ConnType type = ConnType.values()[in.read()];
        System.out.println(name + " [" + name.length() + "]");
        return new ShakenSocket(name, null, s);
    }

    private void fixSocket(Socket s) throws IOException {
        s.setSoLinger(false, 0);
        s.setTcpNoDelay(true);
    }

    private static enum ConnType {
        AUTHENTICATED,
        ANONYMOUS,
        UNAUTHENTICATED;

    }
}

