/*
 * Decompiled with CFR 0.152.
 */
package fabric.common.net;

import fabric.common.net.Channel;
import fabric.common.net.NotImplementedException;
import fabric.common.net.SubSocket;
import fabric.common.net.handshake.HandshakeProtocol;
import fabric.common.net.naming.NameService;
import fabric.common.net.naming.SocketAddress;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public final class SubSocketFactory {
    private final HandshakeProtocol protocol;
    private final NameService nameService;
    private final Map<String, ClientChannel> channels;

    public SubSocketFactory(HandshakeProtocol protocol, NameService nameService) {
        this.protocol = protocol;
        this.nameService = nameService;
        this.channels = new HashMap<String, ClientChannel>();
    }

    public SubSocket createSocket() {
        return new SubSocket(this);
    }

    public SubSocket createSocket(String name) throws IOException {
        SubSocket result = this.createSocket();
        result.connect(name);
        return result;
    }

    synchronized ClientChannel getChannel(String name) throws IOException {
        ClientChannel result = this.channels.get(name);
        if (null == result) {
            result = new ClientChannel(name, this.nameService.resolve(name));
            this.channels.put(name, result);
        }
        return result;
    }

    class ClientChannel
    extends Channel {
        private final String name;
        private final SocketAddress addr;
        private int nextSequenceNumber;

        public ClientChannel(String name, SocketAddress addr) throws IOException {
            super(SubSocketFactory.this.protocol.initiate(name, addr));
            this.addr = addr;
            this.name = name;
            this.nextSequenceNumber = 1;
            this.setName("demultiplexer for " + this.toString());
        }

        public Channel.Connection connect() throws IOException {
            return new Channel.Connection(this.nextSequenceNumber++);
        }

        @Override
        public Channel.Connection accept(int sequence) throws IOException {
            throw new IOException("unexpected accept request on client channel");
        }

        @Override
        public void cleanup() {
            throw new NotImplementedException();
        }

        @Override
        public String toString() {
            return "channel to " + this.name + " [" + this.addr.toString() + "]";
        }
    }
}

