/*
 * Decompiled with CFR 0.152.
 */
package fabric.common.net;

import fabric.common.net.Channel;
import fabric.common.net.SubSocketFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class SubSocket {
    private State state;

    protected SubSocket(SubSocketFactory factory) {
        this.state = new Unconnected(factory);
    }

    SubSocket(Channel.Connection conn) {
        this.state = new Connected(conn);
    }

    public final void close() throws IOException {
        this.state.close();
    }

    public final void connect(String name) throws IOException {
        this.state.connect(name);
    }

    public final OutputStream getOutputStream() throws IOException {
        return this.state.getOutputStream();
    }

    public final InputStream getInputStream() throws IOException {
        return this.state.getInputStream();
    }

    protected final class ErrorState
    extends State {
        public String toString() {
            return "has recieved an exception";
        }

        public ErrorState(Exception exc) {
            this.cause = exc;
        }
    }

    protected final class Closed
    extends State {
        protected Closed() {
        }

        public String toString() {
            return "is closed";
        }
    }

    protected final class Connected
    extends State {
        final Channel.Connection conn;

        public String toString() {
            return "is connected (" + this.conn.toString() + ")";
        }

        @Override
        public void close() throws IOException {
            try {
                this.conn.close();
                SubSocket.this.state = new Closed();
            }
            catch (Exception exc) {
                IOException wrapped = new IOException("failed to close connection", exc);
                SubSocket.this.state = new ErrorState(wrapped);
                throw wrapped;
            }
        }

        @Override
        public InputStream getInputStream() {
            return this.conn.in;
        }

        @Override
        public OutputStream getOutputStream() {
            return this.conn.out;
        }

        public Connected(Channel.Connection conn) {
            this.conn = conn;
        }
    }

    protected final class Unconnected
    extends State {
        private final SubSocketFactory factory;

        public String toString() {
            return "is unconnected";
        }

        @Override
        public void connect(String name) throws IOException {
            try {
                Channel.Connection conn = this.factory.getChannel(name).connect();
                SubSocket.this.state = new Connected(conn);
            }
            catch (Exception exc) {
                IOException wrapped = new IOException("failed to connect to " + name, exc);
                SubSocket.this.state = new ErrorState(wrapped);
                throw wrapped;
            }
        }

        public Unconnected(SubSocketFactory factory) {
            this.factory = factory;
        }
    }

    protected abstract class State {
        protected Exception cause = null;

        protected State() {
        }

        public void close() throws IOException {
            throw new IOException("Cannot close socket: socket " + this, this.cause);
        }

        public void connect(String name) throws IOException {
            throw new IOException("Cannot connect: socket " + this, this.cause);
        }

        public InputStream getInputStream() throws IOException {
            throw new IOException("Cannot get an input stream: socket " + this, this.cause);
        }

        public OutputStream getOutputStream() throws IOException {
            throw new IOException("Cannot get an output stream: socket " + this, this.cause);
        }
    }
}

