/*
 * Decompiled with CFR 0.152.
 */
package fabric.common.net;

import fabric.common.net.Channel;
import fabric.common.net.NotImplementedException;
import fabric.common.net.SubServerSocket;
import fabric.common.net.SubSocket;
import fabric.common.net.handshake.HandshakeProtocol;
import fabric.common.net.handshake.ShakenSocket;
import fabric.common.net.naming.NameService;
import fabric.common.net.naming.SocketAddress;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;

public class SubServerSocketFactory {
    private final HandshakeProtocol handshake;
    private final NameService nameService;
    private final Map<SocketAddress, Acceptor> acceptors;

    public SubServerSocketFactory(HandshakeProtocol handshake, NameService nameService) {
        this.handshake = handshake;
        this.nameService = nameService;
        this.acceptors = new HashMap<SocketAddress, Acceptor>();
    }

    public SubServerSocket createServerSocket() {
        return new SubServerSocket(this);
    }

    public SubServerSocket createServerSocket(String host) throws IOException {
        return this.createServerSocket(host, 50);
    }

    public SubServerSocket createServerSocket(String name, int backlog) throws IOException {
        SubServerSocket result = new SubServerSocket(this);
        result.bind(name, backlog);
        return result;
    }

    synchronized Acceptor.ConnectionQueue bind(String name, int backlog) throws IOException {
        SocketAddress addr = this.nameService.localResolve(name);
        Acceptor a = this.acceptors.get(addr);
        if (null == a) {
            a = new Acceptor(addr);
            this.acceptors.put(addr, a);
        }
        return a.makeQueue(name, backlog);
    }

    synchronized void closeAcceptor(Acceptor a) {
        throw new NotImplementedException();
    }

    class Acceptor
    extends Thread {
        private final SocketAddress address;
        private final Map<String, ConnectionQueue> queues;

        Acceptor(SocketAddress addr) {
            super("connection dispatcher for " + addr);
            this.address = addr;
            this.queues = new HashMap<String, ConnectionQueue>();
            this.start();
        }

        ConnectionQueue makeQueue(String name, int size) throws IOException {
            if (this.queues.containsKey(name)) {
                throw new IOException("attempted to bind multiple SubServerSockets to " + name + " @ " + this.address);
            }
            ConnectionQueue queue = new ConnectionQueue(name, size);
            this.queues.put(name, queue);
            return queue;
        }

        private void closeQueue(ConnectionQueue child) {
            throw new NotImplementedException();
        }

        private void recvConnection(Socket s) {
            try {
                ShakenSocket conn = SubServerSocketFactory.this.handshake.receive(s);
                ConnectionQueue queue = this.queues.get(conn.name);
                if (null == queue) {
                    throw new NotImplementedException();
                }
                queue.open(conn);
            }
            catch (IOException e) {
                throw new NotImplementedException(e);
            }
        }

        private void recvException(IOException e) {
            throw new NotImplementedException(e);
        }

        @Override
        public void run() {
            try {
                ServerSocket sock = new ServerSocket(this.address.getPort(), 0, this.address.getAddress());
                while (true) {
                    try {
                        while (true) {
                            this.recvConnection(sock.accept());
                        }
                    }
                    catch (IOException e) {
                        this.recvException(e);
                        continue;
                    }
                    break;
                }
            }
            catch (IOException exc) {
                throw new NotImplementedException(exc);
            }
        }

        class ConnectionQueue {
            private final String name;
            private final Set<ServerChannel> channels;
            private final BlockingQueue<SubSocket> connections;

            ConnectionQueue(String name, int size) {
                this.name = name;
                this.channels = new HashSet<ServerChannel>();
                this.connections = new ArrayBlockingQueue<SubSocket>(size);
            }

            void close() {
                throw new NotImplementedException();
            }

            SubSocket accept() throws IOException {
                try {
                    return this.connections.take();
                }
                catch (InterruptedException e) {
                    throw new NotImplementedException(e);
                }
            }

            void open(ShakenSocket s) throws IOException {
                this.channels.add(new ServerChannel(s));
            }

            private void receive(SubSocket s) {
                try {
                    this.connections.add(s);
                }
                catch (IllegalStateException e) {
                    throw new NotImplementedException(e);
                }
            }

            public String toString() {
                return this.name + " [" + Acceptor.this.address + "]";
            }

            class ServerChannel
            extends Channel {
                ServerChannel(ShakenSocket sock) throws IOException {
                    super(sock);
                    this.setName("demultiplexer for " + this.toString());
                }

                @Override
                protected Channel.Connection accept(int sequence) throws IOException {
                    Channel.Connection result = new Channel.Connection(sequence);
                    SubSocket socket = new SubSocket(result);
                    ConnectionQueue.this.receive(socket);
                    return result;
                }

                @Override
                protected void cleanup() {
                    throw new NotImplementedException();
                }

                @Override
                public String toString() {
                    return "channel from " + this.sock.getInetAddress() + " to " + ConnectionQueue.this.toString();
                }
            }
        }
    }
}

