/*
 * Decompiled with CFR 0.152.
 */
package fabric.common.net;

import fabric.common.net.SubServerSocketFactory;
import fabric.common.net.SubSocket;
import java.io.IOException;

public class SubServerSocket {
    private State state;

    protected SubServerSocket(SubServerSocketFactory factory) {
        this.state = new Unbound(factory);
    }

    public SubSocket accept() throws IOException {
        return this.state.accept();
    }

    public void bind(String name) throws IOException {
        this.bind(name, 50);
    }

    public void bind(String name, int backlog) throws IOException {
        this.state.bind(name, backlog);
    }

    public void close() throws IOException {
        this.state.close();
    }

    private final class ErrorState
    extends State {
        public String toString() {
            return "has recieved an exception";
        }

        public ErrorState(Exception exc) {
            this.cause = exc;
        }
    }

    private final class Closed
    extends State {
        private Closed() {
        }

        public String toString() {
            return "is closed";
        }
    }

    private final class Bound
    extends State {
        final SubServerSocketFactory.Acceptor.ConnectionQueue queue;

        public String toString() {
            return "is bound to " + this.queue;
        }

        @Override
        public SubSocket accept() throws IOException {
            try {
                return this.queue.accept();
            }
            catch (IOException e) {
                IOException wrapped = new IOException("failed to accept (socket " + this + ")", e);
                SubServerSocket.this.state = new ErrorState(wrapped);
                throw wrapped;
            }
        }

        @Override
        public void close() {
            this.queue.close();
            SubServerSocket.this.state = new Closed();
        }

        public Bound(SubServerSocketFactory.Acceptor.ConnectionQueue queue) {
            this.queue = queue;
        }
    }

    private final class Unbound
    extends State {
        private final SubServerSocketFactory factory;

        public String toString() {
            return "is unbound";
        }

        @Override
        public void bind(String name, int backlog) throws IOException {
            try {
                SubServerSocketFactory.Acceptor.ConnectionQueue queue = this.factory.bind(name, backlog);
                SubServerSocket.this.state = new Bound(queue);
            }
            catch (Exception exc) {
                IOException wrapped = new IOException("failed to bind to local address " + name, exc);
                SubServerSocket.this.state = new ErrorState(wrapped);
                throw wrapped;
            }
        }

        public Unbound(SubServerSocketFactory factory) {
            this.factory = factory;
        }
    }

    private abstract class State {
        protected Exception cause = null;

        private State() {
        }

        public SubSocket accept() throws IOException {
            throw new IOException("Cannot accept a connection because server socket " + this, this.cause);
        }

        public void bind(String name, int backlog) throws IOException {
            throw new IOException("Cannot bind to local address " + name + " because server socket " + this, this.cause);
        }

        public void close() throws IOException {
            throw new IOException("Cannot close server socket because it " + this, this.cause);
        }
    }
}

