/*
 * Decompiled with CFR 0.152.
 */
package fabric.common.net;

import fabric.common.Logging;
import fabric.common.net.NotImplementedException;
import fabric.common.net.handshake.ShakenSocket;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

abstract class Channel
extends Thread {
    private final DataOutputStream out;
    private final DataInputStream in;
    protected final Socket sock;
    private final Map<Integer, Connection> connections;

    protected Channel(ShakenSocket s) throws IOException {
        this.sock = s.sock;
        this.out = new DataOutputStream(this.sock.getOutputStream());
        this.in = new DataInputStream(this.sock.getInputStream());
        this.connections = new HashMap<Integer, Connection>();
        this.start();
    }

    @Override
    public abstract String toString();

    protected abstract Connection accept(int var1) throws IOException;

    protected abstract void cleanup();

    public synchronized void sendClose() throws IOException {
        this.out.writeInt(0);
        this.out.flush();
    }

    public synchronized void sendClose(int sequence) throws IOException {
        this.out.writeInt(sequence);
        this.out.writeInt(0);
        this.out.flush();
    }

    public synchronized void sendData(int sequence, byte[] data, int offset, int len) throws IOException {
        Logging.NETWORK_CHANNEL_LOGGER.log(Level.FINE, "sending " + len + " bytes of data on {0}", this);
        this.out.writeInt(sequence);
        this.out.writeInt(len);
        this.out.write(data, offset, len);
        this.out.flush();
    }

    public synchronized void recvClose() {
        throw new NotImplementedException();
    }

    public synchronized void recvClose(int sequence) throws IOException {
        Connection listener = this.getReceiver(sequence);
        listener.close();
    }

    public synchronized void recvData(int sequence, byte[] data) throws IOException {
        Connection listener = this.getReceiver(sequence);
        listener.receiveData(data);
    }

    private synchronized Connection getReceiver(int sequence) throws IOException {
        Connection result = this.connections.get(sequence);
        if (result == null) {
            result = this.accept(sequence);
        }
        return result;
    }

    @Override
    public void run() {
        try {
            while (true) {
                int sequenceNumber;
                if ((sequenceNumber = this.in.readInt()) == 0) {
                    this.recvClose();
                    continue;
                }
                int len = this.in.readInt();
                if (len == 0) {
                    this.recvClose(sequenceNumber);
                    continue;
                }
                byte[] buf = new byte[len];
                this.in.read(buf);
                Logging.NETWORK_CHANNEL_LOGGER.log(Level.FINE, "received " + len + " bytes on {0}", this);
                this.recvData(sequenceNumber, buf);
            }
        }
        catch (IOException exc) {
            throw new NotImplementedException(exc);
        }
    }

    private class MuxedOutputStream
    extends OutputStream {
        private final int sequenceNumber;

        public MuxedOutputStream(int sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
        }

        @Override
        public void write(int arg0) throws IOException {
            throw new IOException("MuxedOutputStreams do not support writing unbuffered data");
        }

        @Override
        public void write(byte[] buf, int offset, int len) throws IOException {
            Channel.this.sendData(this.sequenceNumber, buf, offset, len);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }
    }

    class Connection {
        public final int sequenceNum;
        public final InputStream in;
        public final OutputStream out;
        public final OutputStream sink;

        public Connection(int sequenceNum) throws IOException {
            this.sequenceNum = sequenceNum;
            this.out = new BufferedOutputStream(new MuxedOutputStream(sequenceNum));
            PipedInputStream in = new PipedInputStream();
            this.sink = new PipedOutputStream(in);
            this.in = in;
            Channel.this.connections.put(this.sequenceNum, this);
        }

        public String toString() {
            return "stream " + this.sequenceNum + " on " + Channel.this.toString();
        }

        public void close() throws IOException {
            throw new NotImplementedException();
        }

        public void receiveClose() throws IOException {
            throw new NotImplementedException();
        }

        public void receiveData(byte[] b) throws IOException {
            Logging.NETWORK_CHANNEL_LOGGER.fine("putting data in pipe");
            this.sink.write(b);
            this.sink.flush();
        }
    }
}

