/*
 * Decompiled with CFR 0.152.
 */
package fabric.common;

import fabric.common.Crypto;
import fabric.common.Logging;
import fabric.lang.Codebase;
import fabric.lang.FabricClassLoader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.net.URL;
import java.security.MessageDigest;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Level;

public final class Util {
    private static final Map<String, byte[]> classHashCache = Collections.synchronizedMap(new HashMap());
    private static final int BUF_LEN = 4096;

    private static String getCacheKey(Codebase codebase, String className) {
        if (codebase == null) {
            return className;
        }
        return "fab://" + codebase.$getStore().name() + "/" + codebase.$getOnum() + "/" + className;
    }

    public static byte[] hash(Class<?> c) throws IOException {
        InputStream classIn;
        Codebase codebase = null;
        if (c.getClassLoader() instanceof FabricClassLoader) {
            FabricClassLoader cl = (FabricClassLoader)c.getClassLoader();
            codebase = cl.getCodebase();
        }
        String className = c.getName();
        String cacheKey = Util.getCacheKey(codebase, className);
        Logging.CLASS_HASHING_LOGGER.log(Level.FINE, "Hashing class by class object: {0}", cacheKey);
        byte[] result = classHashCache.get(cacheKey);
        if (result != null) {
            Logging.CLASS_HASHING_LOGGER.finer("  Hash found in cache");
            return result;
        }
        MessageDigest digest = Crypto.digestInstance();
        ClassLoader classLoader = c.getClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        String classFileName = className.replace('.', '/') + ".class";
        if (Logging.CLASS_HASHING_LOGGER.isLoggable(Level.FINEST)) {
            URL classResource = classLoader.getResource(classFileName);
            Logging.log(Logging.CLASS_HASHING_LOGGER, Level.FINEST, "  Using {0} to load class bytecode from {1}", classLoader, classResource);
        }
        if ((classIn = classLoader.getResourceAsStream(classFileName)) == null) {
            Logging.log(Logging.CLASS_HASHING_LOGGER, Level.WARNING, "Unable to load {0} from {1} using {2}", className, classFileName, classLoader);
            throw new InternalError("Class not found: " + className);
        }
        byte[] buf = new byte[4096];
        int count = classIn.read(buf);
        while (count != -1) {
            digest.update(buf, 0, count);
            count = classIn.read(buf);
        }
        classIn.close();
        Class<?> superClass = c.getSuperclass();
        if (superClass != null) {
            digest.update(Util.hash(superClass));
        }
        result = digest.digest();
        classHashCache.put(cacheKey, result);
        if (Logging.CLASS_HASHING_LOGGER.isLoggable(Level.FINEST)) {
            String hash = new BigInteger(1, result).toString(16);
            Logging.log(Logging.CLASS_HASHING_LOGGER, Level.FINEST, "  Hash for {0} is {1}", className, hash);
        }
        return result;
    }

    public static byte[] hashClass(Codebase codebase, String className) throws IOException, ClassNotFoundException {
        Logging.CLASS_HASHING_LOGGER.log(Level.FINE, "Hashing class by name: {0}", className);
        String cacheKey = Util.getCacheKey(codebase, className);
        byte[] result = classHashCache.get(cacheKey);
        if (result != null) {
            Logging.CLASS_HASHING_LOGGER.finer("  Hash found in cache");
            return result;
        }
        if (codebase == null) {
            return Util.hash(Class.forName(className));
        }
        return Util.hash(FabricClassLoader.getClassLoader((Codebase)codebase).findClass(className));
    }

    public static URL locateClass(Codebase codebase, String className) throws ClassNotFoundException {
        Class c = codebase == null ? Class.forName(className) : FabricClassLoader.getClassLoader((Codebase)codebase).findClass(className);
        ClassLoader classLoader = c.getClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        URL result = classLoader.getResource(className.replace('.', '/') + ".class");
        return result;
    }

    public static <T> Iterable<T> chain(final Iterable<T> ... iters) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){
                    private int i = 0;
                    private Iterator<T> current = null;

                    private void advance() {
                        while (this.current == null && this.i < iters.length) {
                            this.current = iters[this.i++].iterator();
                            if (this.current.hasNext()) continue;
                            this.current = null;
                        }
                    }

                    @Override
                    public boolean hasNext() {
                        this.advance();
                        return this.current != null;
                    }

                    @Override
                    public T next() {
                        this.advance();
                        if (this.current == null) {
                            throw new NoSuchElementException();
                        }
                        Object result = this.current.next();
                        if (!this.current.hasNext()) {
                            this.current = null;
                        }
                        return result;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static byte[] serialize(Object obj) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(obj);
        oos.flush();
        baos.flush();
        return baos.toByteArray();
    }

    public static Object deserialize(byte[] bytes) throws IOException, ClassNotFoundException {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        ObjectInputStream ois = new ObjectInputStream(bais);
        return ois.readObject();
    }
}

