/*
 * Decompiled with CFR 0.152.
 */
package fabric.common;

import fabric.common.FastSerializable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.security.SecureRandom;
import java.util.Random;

public class TransactionID
implements FastSerializable,
Serializable {
    private static final Random rand = new SecureRandom();
    public final TransactionID parent;
    public final long tid;
    public final long topTid;
    public final int depth;

    public TransactionID() {
        this((TransactionID)null);
    }

    public TransactionID(long tid) {
        this(null, tid);
    }

    public TransactionID(TransactionID parent) {
        this(parent, TransactionID.newTid());
    }

    public TransactionID(DataInput in) throws IOException {
        this(in.readBoolean() ? new TransactionID(in) : null, in.readLong());
    }

    private TransactionID(TransactionID parent, long tid) {
        this.parent = parent;
        this.tid = tid;
        if (parent == null) {
            this.depth = 0;
            this.topTid = tid;
        } else {
            this.depth = parent.depth + 1;
            this.topTid = parent.topTid;
        }
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeBoolean(this.parent != null);
        if (this.parent != null) {
            this.parent.write(out);
        }
        out.writeLong(this.tid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long newTid() {
        Random random = rand;
        synchronized (random) {
            return rand.nextLong();
        }
    }

    public boolean isDescendantOf(TransactionID tid) {
        if (this.topTid != tid.topTid) {
            return false;
        }
        if (this.depth < tid.depth) {
            return false;
        }
        TransactionID ancestor = this;
        while (ancestor.depth != tid.depth) {
            ancestor = ancestor.parent;
        }
        return ancestor.equals(tid);
    }

    public boolean equals(Object o) {
        if (!(o instanceof TransactionID)) {
            return false;
        }
        return this.equals((TransactionID)o);
    }

    public boolean equals(TransactionID tid) {
        if (this.topTid != tid.topTid || this.depth != tid.depth) {
            return false;
        }
        TransactionID tid1 = this;
        TransactionID tid2 = tid;
        while (tid1 != tid2) {
            if (tid1.tid != tid2.tid) {
                return false;
            }
            tid1 = tid1.parent;
            tid2 = tid2.parent;
        }
        return true;
    }

    public TransactionID getLowestCommonAncestor(TransactionID tid) {
        TransactionID ancestor2;
        TransactionID ancestor1;
        if (tid == null) {
            return null;
        }
        if (this.depth < tid.depth) {
            ancestor1 = this;
            ancestor2 = tid;
        } else {
            ancestor1 = tid;
            ancestor2 = this;
        }
        while (ancestor2.depth > ancestor1.depth) {
            ancestor2 = ancestor2.parent;
        }
        while (ancestor1 != ancestor2 && ancestor1.tid != ancestor2.tid && !ancestor1.equals(ancestor2)) {
            ancestor1 = ancestor1.parent;
            ancestor2 = ancestor2.parent;
        }
        return ancestor1;
    }
}

