/*
 * Decompiled with CFR 0.152.
 */
package fabric.common;

import fabric.common.FastSerializable;
import fabric.common.ONumConstants;
import fabric.common.RefTypeEnum;
import fabric.common.Surrogate;
import fabric.common.Util;
import fabric.common.exceptions.InternalError;
import fabric.common.util.ComparablePair;
import fabric.common.util.Pair;
import fabric.lang.Codebase;
import fabric.lang.FabricClassLoader;
import fabric.lang.Object;
import fabric.lang.security.Label;
import fabric.worker.LocalStore;
import fabric.worker.RemoteStore;
import fabric.worker.Store;
import fabric.worker.Worker;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public final class SerializedObject
implements FastSerializable,
Serializable {
    private byte[] objectData;
    private String className;
    private static final RefTypeEnum[] refTypeEnums = RefTypeEnum.values();
    private static final Map<String, Codebase> codebaseTable = Collections.synchronizedMap(new HashMap());
    private static final int BUF_LEN = 128;
    private static final byte BUF_LEN_LOG_2 = 7;
    private static final byte BUF_LEN_MASK = 127;
    private static final Map<String, Constructor<?>> constructorTable = Collections.synchronizedMap(new HashMap());

    public SerializedObject(Object._Impl obj) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(baos);
            SerializedObject.write(obj, out);
            out.flush();
            baos.flush();
            this.objectData = baos.toByteArray();
        }
        catch (IOException e) {
            throw new InternalError("Unexpected I/O error.", e);
        }
    }

    public SerializedObject(long onum, long label, Pair<String, Long> remoteRef) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeUTF((String)remoteRef.first);
            oos.writeLong((Long)remoteRef.second);
            oos.flush();
            byte[] serializedData = baos.toByteArray();
            baos = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(baos);
            out.writeLong(onum);
            out.writeInt(0);
            out.writeLong(0L);
            out.writeBoolean(false);
            out.writeLong(label);
            out.writeBoolean(true);
            byte[] className = Surrogate.class.getName().getBytes("UTF-8");
            out.writeShort(className.length);
            out.write(className);
            byte[] classHash = Util.hash(Surrogate.class);
            out.writeShort(classHash.length);
            out.write(classHash);
            out.writeInt(0);
            out.writeInt(0);
            out.writeInt(serializedData.length);
            out.writeInt(0);
            out.write(serializedData);
            out.flush();
            baos.flush();
            this.objectData = baos.toByteArray();
        }
        catch (IOException e) {
            throw new InternalError("Unexpected I/O error.", e);
        }
    }

    private final int onumPos() {
        return 0;
    }

    public long getOnum() {
        return this.longAt(this.onumPos());
    }

    private final int versionPos() {
        return this.onumPos() + 8;
    }

    public int getVersion() {
        return this.intAt(this.versionPos());
    }

    public void setVersion(int version) {
        this.setIntAt(this.versionPos(), version);
    }

    private final int expiryPos() {
        return this.versionPos() + 4;
    }

    public long getExpiry() {
        return this.longAt(this.expiryPos());
    }

    public void setExpiry(long expiry) {
        this.setLongAt(this.expiryPos(), expiry);
    }

    private final int isInterStoreLabelPos() {
        return this.expiryPos() + 8;
    }

    public boolean labelRefIsInterStore() {
        return this.booleanAt(this.isInterStoreLabelPos());
    }

    private final int labelPos() {
        return this.isInterStoreLabelPos() + 1;
    }

    public ComparablePair<String, Long> getInterStoreLabelRef() {
        if (!this.labelRefIsInterStore()) {
            throw new InternalError("Unsupported operation: Attempted to get an inter-store reference to an intra-store label.");
        }
        int labelPos = this.labelPos();
        int storeNameLength = this.unsignedShortAt(labelPos);
        int onumPos = labelPos + 2 + storeNameLength;
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(this.objectData, labelPos, onumPos));
        try {
            return new ComparablePair<String, Long>(in.readUTF(), this.longAt(onumPos));
        }
        catch (IOException e) {
            throw new InternalError("Error while reading store name.", e);
        }
    }

    public long getLabelOnum() {
        if (this.labelRefIsInterStore()) {
            throw new InternalError("Unsupported operation: Attempted to get label onum of an object whose inter-store references have not yet been swizzled." + this.getInterStoreLabelRef());
        }
        return this.longAt(this.labelPos());
    }

    private final int isSystemClassPos() {
        int labelPos = this.labelPos();
        return labelPos + 8 + (this.labelRefIsInterStore() ? this.unsignedShortAt(labelPos) + 2 : 0);
    }

    public boolean isSystemClass() {
        return this.booleanAt(this.isSystemClassPos());
    }

    private final int codebasePos() {
        return this.isSystemClassPos() + 1;
    }

    public Codebase getCodebase() {
        if (this.isSystemClass()) {
            return null;
        }
        int cbPos = this.codebasePos();
        int storeNameLength = this.unsignedShortAt(cbPos);
        int onumPos = cbPos + 2 + storeNameLength;
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(this.objectData, cbPos, onumPos));
        try {
            String cbStoreName = in.readUTF();
            long cbOnum = this.longAt(onumPos);
            String cbKey = "fab://" + cbStoreName + "/" + cbOnum;
            Codebase cb = codebaseTable.get(cbKey);
            if (cb == null) {
                RemoteStore cbStore = Worker.getWorker().getStore(cbStoreName);
                cb = (Codebase)Object._Proxy.$getProxy(new Object._Proxy(cbStore, cbOnum));
                codebaseTable.put(cbKey, cb);
            }
            return cb;
        }
        catch (IOException e) {
            throw new InternalError("Error while reading codebase oid.", e);
        }
        catch (Exception e) {
            throw new InternalError("Error while getting codebase", e);
        }
    }

    private final int classNamePos() {
        int offset = this.codebasePos();
        return offset + (this.isSystemClass() ? 0 : 2 + this.unsignedShortAt(offset) + 8);
    }

    public String getClassName() {
        if (this.className == null) {
            int classNamePos = this.classNamePos();
            int length = this.unsignedShortAt(classNamePos);
            try {
                this.className = new String(this.objectData, classNamePos + 2, length, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new InternalError(e);
            }
        }
        return this.className;
    }

    private final int classHashPos() {
        int classNamePos = this.classNamePos();
        return classNamePos + 2 + this.unsignedShortAt(classNamePos);
    }

    private boolean checkClassHash(byte[] hash) {
        int classHashPos = this.classHashPos();
        if (hash.length != this.unsignedShortAt(classHashPos)) {
            return false;
        }
        for (int i = 0; i < hash.length; ++i) {
            if (hash[i] == this.objectData[classHashPos + i + 2]) continue;
            return false;
        }
        return true;
    }

    private final int numRefTypesPos() {
        int classHashPos = this.classHashPos();
        return classHashPos + 2 + this.unsignedShortAt(classHashPos);
    }

    public final int getNumRefTypes() {
        return this.intAt(this.numRefTypesPos());
    }

    private final int numIntraStoreRefsPos() {
        return this.numRefTypesPos() + 4;
    }

    public final int getNumIntraStoreRefs() {
        return this.intAt(this.numIntraStoreRefsPos());
    }

    private final int serializedDataLengthPos() {
        return this.numIntraStoreRefsPos() + 4;
    }

    private final int serializedDataLength() {
        return this.intAt(this.serializedDataLengthPos());
    }

    private final int numInterStoreRefsPos() {
        return this.serializedDataLengthPos() + 4;
    }

    public final int getNumInterStoreRefs() {
        return this.intAt(this.numInterStoreRefsPos());
    }

    private final int refTypesPos() {
        return this.numInterStoreRefsPos() + 4;
    }

    public Iterator<RefTypeEnum> getRefTypeIterator() {
        final int numRefTypes = this.getNumRefTypes();
        final int offset = this.refTypesPos();
        return new Iterator<RefTypeEnum>(){
            int nextRefTypeNum = 0;

            @Override
            public boolean hasNext() {
                return this.nextRefTypeNum < numRefTypes;
            }

            @Override
            public RefTypeEnum next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return refTypeEnums[SerializedObject.this.objectData[offset + this.nextRefTypeNum++]];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private final int intraStoreRefsPos() {
        return this.refTypesPos() + this.getNumRefTypes();
    }

    public Iterator<Long> getIntraStoreRefIterator() {
        final int numIntraStoreRefs = this.getNumIntraStoreRefs();
        final int offset = this.intraStoreRefsPos();
        return new Iterator<Long>(){
            int nextIntraStoreRefNum = 0;

            @Override
            public boolean hasNext() {
                return this.nextIntraStoreRefNum < numIntraStoreRefs;
            }

            @Override
            public Long next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return SerializedObject.this.longAt(offset + 8 * this.nextIntraStoreRefNum++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private final int serializedDataPos() {
        return this.intraStoreRefsPos() + 8 * this.getNumIntraStoreRefs();
    }

    public InputStream getSerializedDataStream() {
        int serializedDataLength = this.serializedDataLength();
        return new ByteArrayInputStream(this.objectData, this.serializedDataPos(), serializedDataLength);
    }

    private final int interStoreRefsPos() {
        return this.serializedDataPos() + this.serializedDataLength();
    }

    public Iterator<ComparablePair<String, Long>> getInterStoreRefIterator() {
        final int numInterStoreRefs = this.getNumInterStoreRefs();
        final int offset = this.interStoreRefsPos();
        return new Iterator<ComparablePair<String, Long>>(){
            int nextInterStoreRefNum = 0;
            DataInput in = new DataInputStream(new ByteArrayInputStream(SerializedObject.access$100(SerializedObject.this), offset, SerializedObject.access$100(SerializedObject.this).length - offset));

            @Override
            public boolean hasNext() {
                return this.nextInterStoreRefNum < numInterStoreRefs;
            }

            @Override
            public ComparablePair<String, Long> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                ++this.nextInterStoreRefNum;
                try {
                    return new ComparablePair<String, Long>(this.in.readUTF(), this.in.readLong());
                }
                catch (IOException e) {
                    throw new InternalError("Unexpected IO exception.", e);
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public void setRefs(List<Long> intraStoreRefs) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(baos);
            int numIntraStoreRefs = this.getNumIntraStoreRefs();
            Iterator<Long> intraStoreRefIt = intraStoreRefs.iterator();
            out.write(this.objectData, 0, this.isInterStoreLabelPos());
            out.writeBoolean(false);
            if (this.labelRefIsInterStore()) {
                out.writeLong(intraStoreRefIt.next());
            } else {
                out.writeLong(this.getLabelOnum());
            }
            out.write(this.objectData, this.isSystemClassPos(), this.numIntraStoreRefsPos() - this.isSystemClassPos());
            out.writeInt(this.getNumInterStoreRefs() + numIntraStoreRefs);
            out.write(this.objectData, this.serializedDataLengthPos(), 4);
            out.writeInt(0);
            int numRefs = this.getNumRefTypes();
            int REMOTE = RefTypeEnum.REMOTE.ordinal();
            int ONUM = RefTypeEnum.ONUM.ordinal();
            int offset = this.refTypesPos();
            for (int i = 0; i < numRefs; ++i) {
                if (this.objectData[offset] == REMOTE) {
                    out.write(ONUM);
                } else {
                    out.write(this.objectData[offset]);
                }
                ++offset;
            }
            while (intraStoreRefIt.hasNext()) {
                out.writeLong(intraStoreRefIt.next());
            }
            out.write(this.objectData, this.serializedDataPos(), this.serializedDataLength());
            out.flush();
            baos.flush();
            this.objectData = baos.toByteArray();
        }
        catch (IOException e) {
            throw new InternalError("Unexpected I/O error.", e);
        }
    }

    public String toString() {
        return this.getOnum() + "v" + this.getVersion();
    }

    public static void write(Object._Impl impl, DataOutput out) throws IOException {
        Label label = impl.get$label();
        Store labelStore = label.$getStore();
        long labelOnum = label.$getOnum();
        boolean interStoreLabel = !ONumConstants.isGlobalConstant(labelOnum) && !impl.$getStore().equals(labelStore);
        out.writeLong(impl.$getOnum());
        out.writeInt(impl.$version);
        out.writeLong(0L);
        out.writeBoolean(interStoreLabel);
        if (interStoreLabel) {
            if (labelStore instanceof LocalStore) {
                Class<?> objClass = impl.getClass();
                String objStr = impl.toString();
                throw new InternalError("Creating remote ref to local store.  Remote object has class " + objClass + ".  Its string representation " + "is \"" + objStr + "\", and its label is local.");
            }
            out.writeUTF(labelStore.name());
        }
        out.writeLong(labelOnum);
        Class<?> implClass = impl.getClass();
        boolean isSystemClass = !(implClass.getClassLoader() instanceof FabricClassLoader);
        out.writeBoolean(isSystemClass);
        if (!isSystemClass) {
            FabricClassLoader cl = (FabricClassLoader)implClass.getClassLoader();
            Codebase cb = cl.getCodebase();
            byte[] storeName = cb.$getStore().name().getBytes("UTF-8");
            out.writeShort(storeName.length);
            out.write(storeName);
            out.writeLong(cb.$getOnum());
        }
        byte[] className = implClass.getName().getBytes("UTF-8");
        out.writeShort(className.length);
        out.write(className);
        byte[] hash = Util.hash(implClass);
        out.writeShort(hash.length);
        out.write(hash);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        ArrayList<RefTypeEnum> refTypes = new ArrayList<RefTypeEnum>();
        ArrayList<Long> intraStoreRefs = new ArrayList<Long>();
        ArrayList<Pair<String, Long>> interStoreRefs = new ArrayList<Pair<String, Long>>();
        impl.$serialize(oos, refTypes, intraStoreRefs, interStoreRefs);
        oos.flush();
        byte[] serializedData = bos.toByteArray();
        out.writeInt(refTypes.size());
        out.writeInt(intraStoreRefs.size());
        out.writeInt(serializedData.length);
        out.writeInt(interStoreRefs.size());
        for (RefTypeEnum refTypeEnum : refTypes) {
            out.writeByte(refTypeEnum.ordinal());
        }
        for (Long l : intraStoreRefs) {
            out.writeLong(l);
        }
        out.write(serializedData);
        for (Pair pair : interStoreRefs) {
            out.writeUTF((String)pair.first);
            out.writeLong((Long)pair.second);
        }
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.write(this.objectData);
    }

    public SerializedObject(DataInput in) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(bos);
        byte[] buf = new byte[128];
        in.readFully(buf, 0, 20);
        out.write(buf, 0, 20);
        boolean isInterStoreLabel = in.readBoolean();
        out.writeBoolean(isInterStoreLabel);
        int bytesToCopy = 8;
        if (isInterStoreLabel) {
            int storeNameLength = in.readUnsignedShort();
            out.writeShort(storeNameLength);
            bytesToCopy += storeNameLength;
        }
        SerializedObject.copyBytes(in, out, bytesToCopy, buf);
        boolean isSystemClass = in.readBoolean();
        out.writeBoolean(isSystemClass);
        if (!isSystemClass) {
            int storeNameLength = in.readUnsignedShort();
            out.writeShort(storeNameLength);
            SerializedObject.copyBytes(in, out, storeNameLength, buf);
            long cbOnum = in.readLong();
            out.writeLong(cbOnum);
        }
        int classNameLength = in.readUnsignedShort();
        out.writeShort(classNameLength);
        SerializedObject.copyBytes(in, out, classNameLength, buf);
        int classHashLength = in.readUnsignedShort();
        out.writeShort(classHashLength);
        SerializedObject.copyBytes(in, out, classHashLength, buf);
        int numRefTypes = in.readInt();
        out.writeInt(numRefTypes);
        int numIntraStoreRefs = in.readInt();
        out.writeInt(numIntraStoreRefs);
        int serializedDataLength = in.readInt();
        out.writeInt(serializedDataLength);
        int numInterStoreRefs = in.readInt();
        out.writeInt(numInterStoreRefs);
        SerializedObject.copyBytes(in, out, numRefTypes + 8 * numIntraStoreRefs + serializedDataLength, buf);
        for (int i = 0; i < numInterStoreRefs; ++i) {
            int len = in.readUnsignedShort();
            out.writeShort(len);
            SerializedObject.copyBytes(in, out, len + 8, buf);
        }
        out.flush();
        bos.flush();
        this.objectData = bos.toByteArray();
    }

    private static final void copyBytes(DataInput in, DataOutput out, int length, byte[] buf) throws IOException {
        int numLoops = length >> 7;
        for (int count = 0; count < numLoops; ++count) {
            in.readFully(buf);
            out.write(buf);
        }
        in.readFully(buf, 0, length & 0x7F);
        out.write(buf, 0, length & 0x7F);
    }

    public Object._Impl deserialize(Store store) {
        try {
            String className = this.getClassName();
            Codebase cb = this.getCodebase();
            if (!this.checkClassHash(Util.hashClass(cb, className))) {
                URL path = Util.locateClass(cb, className);
                throw new InvalidClassException(className, "A class of the same name was found, but its hash did not match the hash in the object fab://" + store.name() + "/" + this.getOnum() + "\n" + "hash from: " + path);
            }
            String ctorkey = cb == null ? className : "fab://" + cb.$getStore().name() + "/" + cb.$getOnum() + "/" + className;
            Constructor<Object> constructor = constructorTable.get(ctorkey);
            if (constructor == null) {
                Class c = cb == null ? Class.forName(this.getClassName()) : FabricClassLoader.getClassLoader((Codebase)cb).findClass(this.getClassName());
                constructor = c.getConstructor(Store.class, Long.TYPE, Integer.TYPE, Long.TYPE, Long.TYPE, ObjectInput.class, Iterator.class, Iterator.class);
                constructorTable.put(className, constructor);
            }
            return (Object._Impl)constructor.newInstance(store, this.getOnum(), this.getVersion(), this.getExpiry(), this.getLabelOnum(), new ObjectInputStream(this.getSerializedDataStream()), this.getRefTypeIterator(), this.getIntraStoreRefIterator());
        }
        catch (Exception e) {
            throw new InternalError(e);
        }
    }

    private final boolean booleanAt(int pos) {
        return this.objectData[pos] == 1;
    }

    private final int unsignedShortAt(int pos) {
        return (this.objectData[pos + 0] & 0xFF) << 8 | (this.objectData[pos + 1] & 0xFF) << 0;
    }

    private final int intAt(int pos) {
        return (this.objectData[pos + 0] & 0xFF) << 24 | (this.objectData[pos + 1] & 0xFF) << 16 | (this.objectData[pos + 2] & 0xFF) << 8 | (this.objectData[pos + 3] & 0xFF) << 0;
    }

    private final void setIntAt(int pos, int value) {
        this.objectData[pos + 0] = (byte)(0xFF & value >> 24);
        this.objectData[pos + 1] = (byte)(0xFF & value >> 16);
        this.objectData[pos + 2] = (byte)(0xFF & value >> 8);
        this.objectData[pos + 3] = (byte)(0xFF & value >> 0);
    }

    private final long longAt(int pos) {
        return (long)(this.objectData[pos + 0] & 0xFF) << 56 | (long)(this.objectData[pos + 1] & 0xFF) << 48 | (long)(this.objectData[pos + 2] & 0xFF) << 40 | (long)(this.objectData[pos + 3] & 0xFF) << 32 | (long)(this.objectData[pos + 4] & 0xFF) << 24 | (long)(this.objectData[pos + 5] & 0xFF) << 16 | (long)(this.objectData[pos + 6] & 0xFF) << 8 | (long)(this.objectData[pos + 7] & 0xFF) << 0;
    }

    private final void setLongAt(int pos, long value) {
        this.objectData[pos + 0] = (byte)(0xFFL & value >> 56);
        this.objectData[pos + 1] = (byte)(0xFFL & value >> 48);
        this.objectData[pos + 2] = (byte)(0xFFL & value >> 40);
        this.objectData[pos + 3] = (byte)(0xFFL & value >> 32);
        this.objectData[pos + 4] = (byte)(0xFFL & value >> 24);
        this.objectData[pos + 5] = (byte)(0xFFL & value >> 16);
        this.objectData[pos + 6] = (byte)(0xFFL & value >> 8);
        this.objectData[pos + 7] = (byte)(0xFFL & value >> 0);
    }
}

