/*
 * Decompiled with CFR 0.152.
 */
package fabric.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Resources {
    private static final String prefix;

    public static String relpathRewrite(String ... relpath) {
        String filename = prefix;
        for (String name : relpath) {
            filename = filename + File.separator + name;
        }
        return filename;
    }

    public static File getFile(String ... relpath) {
        return new File(Resources.relpathRewrite(relpath));
    }

    public static InputStream readFile(String ... relpath) throws IOException {
        return new FileInputStream(Resources.relpathRewrite(relpath));
    }

    public static OutputStream writeFile(String ... relpath) throws IOException {
        return new FileOutputStream(Resources.relpathRewrite(relpath));
    }

    static {
        String fabHome = System.getenv("FABRIC_HOME");
        if (fabHome == null) {
            fabHome = ".";
        }
        prefix = System.getProperty("fabric.prefix", fabHome);
    }
}

