/*
 * Decompiled with CFR 0.152.
 */
package fabric.common;

import fabric.common.exceptions.UsageError;
import java.io.PrintStream;
import java.util.StringTokenizer;

public abstract class Options {
    public static boolean DEBUG_NO_SSL = false;
    protected static final int USAGE_SCREEN_WIDTH = 76;
    protected static final int USAGE_FLAG_WIDTH = 27;

    protected Options() {
        this.setDefaultValues();
    }

    protected Options(String[] args) throws UsageError {
        this.setDefaultValues();
        this.parseCommandLine(args);
        this.validateOptions();
    }

    protected abstract void setDefaultValues();

    protected abstract void validateOptions() throws UsageError;

    protected abstract int parseCommand(String[] var1, int var2) throws UsageError;

    public void parseCommandLine(String[] args) throws UsageError {
        int i = 0;
        while (i < args.length) {
            try {
                int ni = this.parseCommand(args, i);
                if (ni == i) {
                    throw new UsageError("Illegal option: " + args[i]);
                }
                i = ni;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new UsageError("Missing argument");
            }
        }
    }

    protected static void usageForFlag(PrintStream out, String flag, String desc) {
        out.print("  ");
        out.print(flag);
        int cur = flag.length() + 2;
        if (cur < 27) {
            Options.printSpaces(out, 27 - cur);
        } else {
            out.println();
            Options.printSpaces(out, 27);
        }
        cur = 27;
        StringTokenizer st = new StringTokenizer(desc);
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (cur + s.length() > 76) {
                out.println();
                Options.printSpaces(out, 27);
                cur = 27;
            }
            out.print(s);
            cur += s.length();
            if (!st.hasMoreTokens()) continue;
            if (cur + 1 > 76) {
                out.println();
                Options.printSpaces(out, 27);
                cur = 27;
                continue;
            }
            out.print(" ");
            ++cur;
        }
        out.println();
    }

    protected static void usageForFlag(PrintStream out, String flag, String desc, String defVal) {
        Options.usageForFlag(out, flag, desc + " (default: " + defVal + ")");
    }

    protected static void usageForFlag(PrintStream out, String flag, String desc, int defVal) {
        Options.usageForFlag(out, flag, desc, new Integer(defVal).toString());
    }

    private static void printSpaces(PrintStream out, int n) {
        while (n-- > 0) {
            out.print(' ');
        }
    }
}

