/*
 * Decompiled with CFR 0.152.
 */
package fabric.common;

import fabric.common.SerializedObject;
import fabric.common.util.LongKeyHashMap;
import fabric.common.util.LongKeyMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ObjectGroup {
    private final LongKeyMap<SerializedObject> objects;

    public ObjectGroup(LongKeyMap<SerializedObject> objects) {
        this.objects = objects;
    }

    public LongKeyMap<SerializedObject> objects() {
        return this.objects;
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.objects.size());
        for (SerializedObject obj : this.objects.values()) {
            obj.write(out);
        }
    }

    public ObjectGroup(DataInput in) throws IOException {
        int groupSize = in.readInt();
        this.objects = new LongKeyHashMap<SerializedObject>(groupSize);
        for (int i = 0; i < groupSize; ++i) {
            SerializedObject obj = new SerializedObject(in);
            this.objects.put(obj.getOnum(), obj);
        }
    }
}

