/*
 * Decompiled with CFR 0.152.
 */
package fabric.common;

import fabric.common.Resources;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public final class Logging {
    public static final Logger STORE_REQUEST_LOGGER;
    public static final Logger STORE_TRANSACTION_LOGGER;
    public static final Logger STORE_DB_LOGGER;
    public static final Logger STORE_LOGGER;
    public static final Logger WORKER_TRANSACTION_LOGGER;
    public static final Logger WORKER_LOCAL_STORE_LOGGER;
    public static final Logger WORKER_LOGGER;
    public static final Logger NETWORK_CONNECTION_LOGGER;
    public static final Logger NETWORK_CHANNEL_LOGGER;
    public static final Logger NETWORK_MESSAGE_RECEIVE_LOGGER;
    public static final Logger NETWORK_MESSAGE_SEND_LOGGER;
    public static final Logger CONFIG_LOGGER;
    public static final Logger NAMING_LOGGER;
    public static final Logger CLASS_HASHING_LOGGER;
    public static final Logger MISC_LOGGER;

    public static void log(Logger logger, Level level, String msg, Object param1) {
        if (!logger.isLoggable(level)) {
            return;
        }
        logger.log(level, msg, param1);
    }

    public static void log(Logger logger, Level level, String msg, Object param1, Object param2) {
        if (!logger.isLoggable(level)) {
            return;
        }
        logger.log(level, msg, new Object[]{param1, param2});
    }

    public static void log(Logger logger, Level level, String msg, Object param1, Object param2, Object param3) {
        if (!logger.isLoggable(level)) {
            return;
        }
        logger.log(level, msg, new Object[]{param1, param2, param3});
    }

    public static void log(Logger logger, Level level, String msg, Object param1, Object param2, Object param3, Object param4) {
        if (!logger.isLoggable(level)) {
            return;
        }
        logger.log(level, msg, new Object[]{param1, param2, param3, param4});
    }

    static {
        System.setProperty("java.util.logging.config.class", LogConfigLoader.class.getName());
        STORE_REQUEST_LOGGER = Logger.getLogger("fabric.store.requests");
        STORE_TRANSACTION_LOGGER = Logger.getLogger("fabric.store.transactions");
        STORE_DB_LOGGER = Logger.getLogger("fabric.store.db");
        STORE_LOGGER = Logger.getLogger("fabric.store");
        WORKER_TRANSACTION_LOGGER = Logger.getLogger("fabric.worker.transactions");
        WORKER_LOCAL_STORE_LOGGER = Logger.getLogger("fabric.worker.localstore");
        WORKER_LOGGER = Logger.getLogger("fabric.worker");
        NETWORK_CONNECTION_LOGGER = Logger.getLogger("fabric.net.connections");
        NETWORK_CHANNEL_LOGGER = Logger.getLogger("fabric.net.channel");
        NETWORK_MESSAGE_RECEIVE_LOGGER = Logger.getLogger("fabric.net.messages.received");
        NETWORK_MESSAGE_SEND_LOGGER = Logger.getLogger("fabric.net.messages.sent");
        CONFIG_LOGGER = Logger.getLogger("fabric.config");
        NAMING_LOGGER = Logger.getLogger("fabric.naming");
        CLASS_HASHING_LOGGER = Logger.getLogger("fabric.class_hashing");
        MISC_LOGGER = Logger.getLogger("fabric");
    }

    public static class LogConfigLoader {
        public LogConfigLoader() {
            String configFile = Resources.relpathRewrite("etc", "logging.properties");
            try {
                FileInputStream in = new FileInputStream(configFile);
                Properties p = new Properties();
                p.load(in);
                ((InputStream)in).close();
                String key = "java.util.logging.FileHandler.pattern";
                String logFile = p.getProperty("java.util.logging.FileHandler.pattern");
                if (logFile != null && !new File(logFile).isAbsolute()) {
                    p.setProperty("java.util.logging.FileHandler.pattern", Resources.relpathRewrite(logFile));
                }
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                PrintStream pout = new PrintStream(out);
                for (Map.Entry<Object, Object> entry : p.entrySet()) {
                    pout.println(entry.getKey() + " = " + entry.getValue());
                }
                pout.flush();
                out.flush();
                LogManager.getLogManager().readConfiguration(new ByteArrayInputStream(out.toByteArray()));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

