/*
 * Decompiled with CFR 0.152.
 */
package fabric.common;

import fabric.common.exceptions.InternalError;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXParameters;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.NullCipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.x509.X509V3CertificateGenerator;

public final class Crypto {
    public static final String ALG_SIGNATURE = "SHA256withRSA";
    public static final String ALG_SECRET_KEY_GEN = "AES";
    public static final int SIZE_SECRET_KEY = 128;
    public static final String ALG_SECRET_CRYPTO = "AES/CBC/PKCS5Padding";
    public static final String ALG_PUBLIC_KEY_GEN = "RSA";
    public static final int SIZE_PUBLIC_KEY = 1024;
    public static final String ALG_HASH = "SHA-256";
    private static final KeyGenerator secretKeyGen;
    private static final KeyPairGenerator publicKeyGen;
    private static final SecureRandom random;

    public static MessageDigest digestInstance() {
        try {
            return MessageDigest.getInstance(ALG_HASH);
        }
        catch (NoSuchAlgorithmException e) {
            throw new InternalError(e);
        }
    }

    public static Signature signatureInstance() {
        try {
            return Signature.getInstance(ALG_SIGNATURE);
        }
        catch (NoSuchAlgorithmException e) {
            throw new InternalError(e);
        }
    }

    public static KeyGenerator secretKeyGenInstance() {
        try {
            KeyGenerator result = KeyGenerator.getInstance(ALG_SECRET_KEY_GEN);
            result.init(128);
            return result;
        }
        catch (NoSuchAlgorithmException e) {
            throw new InternalError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SecretKey genSecretKey() {
        KeyGenerator keyGenerator = secretKeyGen;
        synchronized (keyGenerator) {
            return secretKeyGen.generateKey();
        }
    }

    public static KeyPairGenerator publicKeyGenInstance() {
        try {
            KeyPairGenerator result = KeyPairGenerator.getInstance(ALG_PUBLIC_KEY_GEN);
            result.initialize(1024);
            return result;
        }
        catch (NoSuchAlgorithmException e) {
            throw new InternalError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyPair genKeyPair() {
        KeyPairGenerator keyPairGenerator = publicKeyGen;
        synchronized (keyPairGenerator) {
            return publicKeyGen.generateKeyPair();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fillIV(byte[] iv) {
        SecureRandom secureRandom = random;
        synchronized (secureRandom) {
            random.nextBytes(iv);
        }
    }

    public static byte[] makeIV() {
        byte[] result = new byte[16];
        Crypto.fillIV(result);
        return result;
    }

    public static Cipher cipherInstance(int opmode, byte[] key, byte[] iv) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        if (key == null) {
            return new NullCipher();
        }
        Cipher result = Cipher.getInstance(ALG_SECRET_CRYPTO);
        if (iv != null) {
            IvParameterSpec ivSpec = new IvParameterSpec(iv);
            result.init(opmode, (Key)new SecretKeySpec(key, ALG_SECRET_KEY_GEN), ivSpec);
        } else {
            result.init(opmode, new SecretKeySpec(key, ALG_SECRET_KEY_GEN));
        }
        return result;
    }

    public static boolean validateCertificateChain(Certificate[] certificateChain, KeyStore trustStore) {
        try {
            PKIXParameters params = new PKIXParameters(trustStore);
            params.setRevocationEnabled(false);
            CertificateFactory certFactory = CertificateFactory.getInstance("X509");
            CertPath certPath = certFactory.generateCertPath(Arrays.asList(certificateChain));
            CertPathValidator pathValidator = CertPathValidator.getInstance("PKIX");
            pathValidator.validate(certPath, params);
            return true;
        }
        catch (KeyStoreException e) {
        }
        catch (CertificateException e) {
        }
        catch (NoSuchAlgorithmException e) {
        }
        catch (CertPathValidatorException e) {
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            // empty catch block
        }
        return false;
    }

    public X509Certificate createCertificate(String subjectName, PublicKey subjectKey, String issuerName, PrivateKey issuerKey) throws GeneralSecurityException {
        Calendar expiry = Calendar.getInstance();
        expiry.add(1, 1);
        X509V3CertificateGenerator certGen = new X509V3CertificateGenerator();
        certGen.setSerialNumber(BigInteger.valueOf(System.currentTimeMillis()));
        certGen.setIssuerDN(new X509Name("CN=" + issuerName));
        certGen.setSubjectDN(new X509Name("CN=" + subjectName));
        certGen.setSignatureAlgorithm("SHA1WithRSAEncryption");
        certGen.setPublicKey(subjectKey);
        certGen.setNotBefore(new Date(System.currentTimeMillis()));
        certGen.setNotAfter(expiry.getTime());
        return certGen.generate(issuerKey);
    }

    static {
        random = new SecureRandom();
        secretKeyGen = Crypto.secretKeyGenInstance();
        publicKeyGen = Crypto.publicKeyGenInstance();
    }
}

