/*
 * Decompiled with CFR 0.152.
 */
package fabric.common;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class ConsoleFormatter
extends Formatter {
    private static String lineSeparator = System.getProperty("line.separator");
    private static long start = -1L;
    private static int tagWidth = 13;

    @Override
    public String format(LogRecord record) {
        if (start < 0L) {
            start = record.getMillis();
        }
        StringBuilder result = new StringBuilder();
        String level = record.getLevel().toString();
        String time = Long.toString(record.getMillis() - start);
        result.append("[");
        result.append(level);
        result.append(":");
        for (int i = tagWidth - level.length() - time.length(); i > 0; --i) {
            result.append(" ");
        }
        result.append(time);
        result.append("] ");
        result.append(this.formatMessage(record));
        result.append(lineSeparator);
        if (record.getThrown() != null) {
            try {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                record.getThrown().printStackTrace(pw);
                pw.close();
                result.append(sw.toString());
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return result.toString();
    }
}

