/*
 * Decompiled with CFR 0.152.
 */
package fabric.common;

import fabric.common.Logging;
import fabric.common.Resources;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;

public class ConfigProperties {
    public static final Properties defaults = new Properties();
    public final String name;
    public final int workerPort;
    public final String dissemClass;
    public final String keystore;
    public final char[] password;
    public final int maxConnections;
    public final int retries;
    public final int timeout;
    public final boolean useSSL;
    public final String hostname;
    public final String backendClass;
    public final int storePort;
    public final String workerPrincipal;
    public final Properties disseminationProperties;

    public ConfigProperties(String name) {
        this(name, ConfigProperties.readProperties(name));
    }

    public static ConfigProperties getDefaults() {
        return new ConfigProperties("default", new Properties(defaults));
    }

    private ConfigProperties(String name, Properties p) {
        Logging.CONFIG_LOGGER.log(Level.FINE, "properties for {0}", name);
        for (Map.Entry<Object, Object> e : defaults.entrySet()) {
            Logging.CONFIG_LOGGER.log(Level.FINE, " ... {0}", e);
        }
        this.name = name;
        this.password = ConfigProperties.removeProperty(p, "fabric.node.password", "password").toCharArray();
        this.maxConnections = Integer.parseInt(ConfigProperties.removeProperty(p, "fabric.node.maxConnections", "50"));
        this.timeout = Integer.parseInt(ConfigProperties.removeProperty(p, "fabric.node.timeout", "2"));
        this.retries = Integer.parseInt(ConfigProperties.removeProperty(p, "fabric.node.retries", "6"));
        this.useSSL = Boolean.parseBoolean(ConfigProperties.removeProperty(p, "fabric.node.useSSL", "true"));
        this.keystore = Resources.relpathRewrite("etc", "keys", ConfigProperties.removeProperty(p, "fabric.node.keystore", name + ".keystore"));
        this.hostname = ConfigProperties.removeProperty(p, "fabric.node.hostname", name);
        this.workerPort = Integer.parseInt(ConfigProperties.removeProperty(p, "fabric.worker.port", "3372"));
        this.dissemClass = ConfigProperties.removeProperty(p, "fabric.worker.fetchmanager.class", "fabric.dissemination.pastry.PastryFetchManager");
        this.workerPrincipal = ConfigProperties.removeProperty(p, "fabric.worker.principal", null);
        this.storePort = Integer.parseInt(ConfigProperties.removeProperty(p, "fabric.store.port", "3472"));
        this.backendClass = ConfigProperties.removeProperty(p, "fabric.store.db.class", "fabric.store.db.BdbDB");
        this.disseminationProperties = new Properties(defaults);
        for (Object prop : p.keySet()) {
            String key = (String)prop;
            if (key.startsWith("fabric.dissemination.")) {
                this.disseminationProperties.setProperty(key, p.getProperty(key));
                continue;
            }
            Logging.CONFIG_LOGGER.log(Level.WARNING, "Unused property: {0}", key);
        }
    }

    private static String removeProperty(Properties p, String name, String defaultValue) {
        String result = p.getProperty(name, defaultValue);
        p.remove(name);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties readProperties(String name) {
        Properties p = new Properties(defaults);
        InputStream file = null;
        try {
            file = Resources.readFile("etc", "config", name + ".properties");
            p.load(file);
        }
        catch (IOException e) {
        }
        finally {
            try {
                file.close();
            }
            catch (Exception e) {}
        }
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        InputStream in = null;
        try {
            in = Resources.readFile("etc", "config.properties");
            defaults.load(in);
        }
        catch (IOException e) {
        }
        finally {
            try {
                in.close();
            }
            catch (Exception e) {}
        }
        for (Map.Entry<Object, Object> e : defaults.entrySet()) {
            Logging.CONFIG_LOGGER.log(Level.FINE, "default property: {0}", e);
        }
    }
}

